/* $Id: is_error.c,v 1.2 1994/10/10 18:17:05 stuart Exp $ */

#include <lib.h>
#include <transputer/iserver.h>

int iserver_error(int fd, int* error, char* string, int max_len)
{
  char result;      /* Result of write */
  int string_len;   /* Length of result string */
  static char request[1] = { SP_FERROR };
  iovec_t iovec[6] = {
    { (vir_bytes)NULL,    1},   /* Request */
    { (vir_bytes)NULL,    4},   /* fd */
    { (vir_bytes)NULL,    1},   /* result */
    { (vir_bytes)NULL,    4},   /* errno */
    { (vir_bytes)NULL,    2},   /* length */
    { (vir_bytes)NULL,    0}    /* string */
  };

  iovec[0].iov_addr = (vir_bytes)request;
  iovec[1].iov_addr = (vir_bytes)&fd;
  iovec[2].iov_addr = (vir_bytes)&result;
  iovec[3].iov_addr = (vir_bytes)error;
  iovec[4].iov_addr = (vir_bytes)&string_len;
  iovec[5].iov_addr = (vir_bytes)string;
  iovec[5].iov_size = (vir_bytes)max_len;

  string_len = 0;   /* Reset MSBs */

  iserver_message(iovec, 2, (string != NULL) ? 6 : 5);

  if ((result == ER_SUCCESS) && (string != NULL)) {
        if (string_len >= max_len)
                string[max_len-1] = '\0';
        else
                string[string_len] = '\0';
  }
      
  return result;
}
