/* $Id: interrupt.c,v 1.2 1994/10/10 18:17:05 stuart Exp $ */

#include <transputer/channel.h>
#define interrupt _interrupt
#include <minix/type.h>
#include <minix/syslib.h>

extern channel_t* _swiChannelPtr;

void interrupt(int proc_nr)
{
    /* Determine if the schedular process has already responded
     * to an interrupt. */
    while ( (*((volatile int**)_swiChannelPtr))[-3] > (MININT + 3) ) {
#ifdef _ICC
        __asm {
            ldlp    0;
            runp;
            stopp;
        }
#elif defined(__LCC__)
        asm(" ldlp 0");
        asm(" runp");
        asm(" stopp");
#else
#error "Unknown C compiler"
#endif
    }

    ChanOutInt32(_swiChannelPtr, proc_nr);
}
