-- $Id: sem.S,v 1.2 1994/06/20 10:11:19 stuart Exp $

--{{{  Comments
-- Although this is described as a semaphore, it actually implements a
-- simple spin lock. It is designed for mutual exclusion between HPPs and
-- a single low priority task.
--
-- Tasks can call:
--    sem_claim()   to ensure any HPPs are blocked.
--                  (This can be replaced by sem.sem = MININT.)
--    sem_release() to allow any HPPs to run.
-- 
-- HPPs can call:
--    sem_claim()   to ensure they are not locked out by the task or
--                  another HPP.
--    sem_release() to allow any blocked HPPs to run.
--}}}
--{{{  Constants
#define SEM_SEM  0
#define SEM_HEAD 1
#define SEM_TAIL 2
--}}}

--{{{  sem_init
-- Initialise the semaphore. 
-- Called as "void sem_init(sem_s *sem)"
--  2  sem
--  1  gsb
--  0  return Iptr
sem_init:
        global  sem_init
        ldc     0
        ldl     2
        stnl    SEM_SEM
        mint
        ldl     2
        stnl    SEM_HEAD
        ret
--}}}
--{{{  sem_claim
-- Claim the semaphore. If semaphore is already claimed by another, wait.
-- Called as "void sem_claim(sem_s *sem)"
--  2  sem
--  1  gsb
--  0  return Iptr
sem_claim:
        global	sem_claim

        ldl     2
        -- Should be a "ldnlp SEM_SEM" here, but that is a no-op as SEM_SEM=0.
        resetch
        cj      (sc_in - sc_label1)
sc_label1:        

        -- Semaphore was already claimed, wait.
        ldtimer
        ldc 1000
        sum
        tin
        j       (sem_claim - sc_labelxx)
sc_labelxx:

sc_in:
        -- We have now been granted the semaphore.
        ret
--}}}
--{{{  sem_release
-- Release the semaphore.
-- Called as "void sem_claim(sem_s *sem)"
--  2  sem
--  1  gsb
--  0  return Iptr
sem_release:
        global	sem_release

        -- Release the semaphore and return.
        ldc     0
        ldl     2
        stnl    SEM_SEM
        ret
--}}}


