-- $Id: run_process.S,v 1.1 1994/06/17 19:08:08 stuart Exp $

-- Run the indicated process at high prioritpy.
-- Note: stack param is address of top of stack on entry to the function.
-- It is the users responsability to ensure at at least the next four
-- words are free.
--
-- Called as: void run_process(void* stack, void* fn_ptr, int num_params, ...)
--
--  6  ...
--  5  params
--  4  num_params
--  3  fn_ptr
--  2  stack
--  1  gsb
--  0  return Iptr

run_process:
        global  run_process

        -- Copy parameters
        ldlp    5
        ldl     2
        ldnlp   2
        ldl     4
        bcnt
        move    -- A = len, B = dest, C = src

        -- Copy GSB
        ldl     1
        ldl     2
        stnl    1

        -- Set up return Iptr
        ldc     return - here
        ldpi
here:
        ldl     2
        stnl    0

        -- Set up initial Iptr
        ldl     3
        ldl     2
        stnl    -1

        ldl     2
        runp
        ret

        -- This is where the hpp will return to, if it returns.
        -- This will overwrite what has become the -1 workspace slot,
        -- but as this is the 2nd parameter for the call, we dont care.
return:
        stopp
