/* $Id: chanTimeFail.S,v 1.1 1995/10/27 19:27:38 stuart Exp $ */

/*
 * Extrodinary link handling code as described in:
 *     Transputer Instructon Set : A compiler writers guide
 *     (c) INMOS Limited
 *     published by Prentice Hall
 *
 * This implements the C functions:
 *   int ChanInTimeFail(channel_t *c, void *data, int count, int time)
 *   int ChanOutTimeFail(channel_t *c, void *data, int count, int time)
 *
 * Memory usage:
 *    ,-------- I/O process
 *    | ,------ monitor process
 *    | | ,---- after join
 *    | | | ,-- entry
 *    | | | |
 *   15 9 8 5 : time
 *   14 8 7 4 : count
 *   13 7 6 3 : data
 *   12 6 5 2 : chan
 *   11 5 4 1 : GSB / completed channel
 *   10 4 3 0 : Ret Iptr
 *    9 3 2   : result
 *    8 2 1   : endp count
 *    7 1 0   : endp pointer
 *    6 0     : ws0
 *  5-1       : negative ws
 *    0       : ws0
 */

#define IO_ADJUST      10
#define MONITOR_ADJUST 4
#define END_ADJUST     3

#define TIME      (5+ADJUST)
#define COUNT     (4+ADJUST)
#define DATA      (3+ADJUST)
#define CHAN      (2+ADJUST)
#define COMPLETED (1+ADJUST)
#define RESULT    (ADJUST-1)
#define ENDP_C    (ADJUST-2)
#define ENDP_P    (ADJUST-3)
#define MON_BASE  (ADJUST-4)

#define ADJUST IO_ADJUST

ChanInTimeFail:
        global  ChanInTimeFail

	-- Adjust workspace so the monitoring process runs on the
	-- origional stack.
	ajw	-ADJUST

	-- Init completed channel and endp data
	mint
	stl	COMPLETED
        ldc     2
        stl     ENDP_C
        ldc     endp_end - i1
        ldpi
i1:     stl     ENDP_P

	-- Start the monitoring process
	ldc	monitor_process - i2
	ldlp    MON_BASE
        startp
i2:

	-- Perform the communication
	ldl	DATA
	ldl	CHAN
	ldl	COUNT
        in

	-- Signal the monitoring process
        ldlp    COMPLETED
        ldc     0
        outbyte

        -- Join with the other process
        ldlp    ENDP_P
        endp

ChanOutTimeFail:
        global  ChanOutTimeFail

	-- Adjust workspace so the monitoring process runs on the
	-- origional stack.
	ajw	-ADJUST

	-- Init completed channel and endp data
	mint
	stl	COMPLETED
        ldc     2
        stl     ENDP_C
        ldc     endp_end - o1
        ldpi
o1:     stl     ENDP_P

	-- Start the monitoring process
	ldc	monitor_process - o2
	ldlp    MON_BASE
        startp
o2:

	-- Perform the communication
	ldl	DATA
	ldl	CHAN
	ldl	COUNT
        out

	-- Signal the monitoring process
        ldlp    COMPLETED
        ldc     0
        outbyte

        -- Join with the other process
        ldlp    ENDP_P
        endp


#undef ADJUST
#define ADJUST END_ADJUST

        -- After the join, where we start to execute again.
endp_end:
        ldl     RESULT
        ajw     ADJUST
        ret

#undef ADJUST
#define ADJUST MONITOR_ADJUST

monitor_process:
	-- Alt on the timeout or completed channel
        talt
        ldlp	COMPLETED
	ldc	1
        enbc
        ldl	TIME
	ldc	1
        enbt
        taltwt
        ldlp	COMPLETED
	ldc	1
	ldc	completed - end
        disc
        ldl	TIME
	ldc	1
        ldc	timeout - end
        dist
        altend
end:

completed:
	ldlp	0	-- scratch
	ldlp	COMPLETED
	ldc	1
	in

        ldc     0
        stl     RESULT

        -- Join with I/O process
        ldlp    ENDP_P
        endp

timeout:
        ldl	CHAN
	resetch
        stl	0	-- scratch
        ldl	0
	mint
	diff
	cj	not_running - l4
l4:	ldl	0
	runp
not_running:
	ldlp	0	-- scratch
	ldlp	COMPLETED
	ldc	1
	in

        ldc     1
        stl     RESULT

        -- Join with I/O process
        ldlp    ENDP_P
        endp
