/* $Id: chanTimeFail.S,v 1.1 1995/11/23 18:58:55 stuart Exp $ */

/*
 * Extrodinary link handling code as described in:
 *     Transputer Instructon Set : A compiler writers guide
 *     (c) INMOS Limited
 *     published by Prentice Hall
 *
 * This implements the C functions:
 *   int ChanInTimeFail(channel_t *c, void *data, int count, int time)
 *   int ChanOutTimeFail(channel_t *c, void *data, int count, int time)
 *
 * Memory usage (with GSB):          (without GSB):
 * 
 *    ,-------- I/O process             ,-------- I/O process
 *    | ,------ monitor process         | ,------ monitor process
 *    | | ,---- after join              | | ,---- after join
 *    | | | ,-- entry                   | | | ,-- entry
 *    | | | |                           | | | |
 *   15 9 8 5 : time                   15 9 8 4 : time
 *   14 8 7 4 : count                  14 8 7 3 : count
 *   13 7 6 3 : data                   13 7 6 2 : data
 *   12 6 5 2 : chan                   12 6 5 1 : chan
 *   11 5 4 1 : GSB/completed chan     11 5 4 0 : Ret Iptr
 *   10 4 3 0 : Ret Iptr               10 4 3   : completed chan
 *    9 3 2   : result                  9 3 2   : result
 *    8 2 1   : endp count              8 2 1   : endp count
 *    7 1 0   : endp pointer            7 1 0   : endp pointer
 *    6 0     : ws0                     6 0     : ws0
 *  5-1       : negative ws           5-1       : negative ws
 *    0       : ws0                     0       : ws0
 */

#include <transputer/asm.h>

#if HAS_GSB
/* If we have a GSB parameter, it is used for the completed channel. */
#define IO_ADJUST    10
#define MON_ADJUST    4
#define END_ADJUST    3
#else
/* With no GSB parameter, an additonal word of workspace is allocated. */
#define IO_ADJUST      11
#define MONITOR_ADJUST 5
#define END_ADJUST     4
#endif

#define IO_TIME      15
#define IO_COUNT     14
#define IO_DATA      13
#define IO_CHAN      12
#ifdef HAS_GSB
#define IO_COMPLETED 11
#else
#define IO_COMPLETED 10
#endif
#define IO_RESULT     9
#define IO_ENDP_C     8
#define IO_ENDP_P     7
#define IO_MON_BASE   6

#define MON_TIME      9
#define MON_COUNT     8
#define MON_DATA      7
#define MON_CHAN      6
#ifdef HAS_GSB
#define MON_COMPLETED 5
#else
#define MON_COMPLETED 4
#endif
#define MON_RESULT    3
#define MON_ENDP_C    2
#define MON_ENDP_P    1
#define MON_MON_BASE  0

#define END_TIME      8
#define END_COUNT     7
#define END_DATA      6
#define END_CHAN      5
#ifdef HAS_GSB
#define END_COMPLETED 4
#else
#define END_COMPLETED 3
#endif
#define END_RESULT    2
#define END_ENDP_C    1
#define END_ENDP_P    0

GLABEL(ChanInTimeFail)
        /* Adjust workspace so the monitoring process runs on the
         * origional stack. */
        ajw     -IO_ADJUST

        /* Init completed channel and endp data. */
        mint
        stl     IO_COMPLETED
        ldc     2
        stl     IO_ENDP_C
        LDCODEADDR(endp_end)
        stl     IO_ENDP_P

        /* Start the monitoring process */
#ifdef _ICC
        ldc     monitor_process - i2
#endif
#ifdef __LCC__
        equ @_1,monitor_process-i2
        ldc @_1
#endif
        ldlp    IO_MON_BASE
        startp
LABEL(i2)

        /* Perform the communication */
        ldl     IO_DATA
        ldl     IO_CHAN
        ldl     IO_COUNT
        in

        /* Signal the monitoring process */
        ldlp    IO_COMPLETED
        ldc     0
        outbyte

        /* Join with the other process */
        ldlp    IO_ENDP_P
        endp

GLABEL(ChanOutTimeFail)

        /* Adjust workspace so the monitoring process runs on the
         * origional stack. */
        ajw     -IO_ADJUST

        /* Init completed channel and endp data */
        mint
        stl     IO_COMPLETED
        ldc     2
        stl     IO_ENDP_C
        LDCODEADDR(endp_end)
        stl     IO_ENDP_P

        /* Start the monitoring process */
#ifdef _ICC
        ldc     monitor_process - o2
#endif
#ifdef __LCC__
        equ     @_2,monitor_process-o2
        ldc     @_2
#endif
        ldlp    IO_MON_BASE
        startp
LABEL(o2)

        /* Perform the communication */
        ldl     IO_DATA
        ldl     IO_CHAN
        ldl     IO_COUNT
        out

        /* Signal the monitoring process */
        ldlp    IO_COMPLETED
        ldc     0
        outbyte

        /* Join with the other process */
        ldlp    IO_ENDP_P
        endp


        /* After the join, where we start to execute again. */
LABEL(endp_end)
        ldl     END_RESULT
        ajw     END_ADJUST
        ret

LABEL(monitor_process)
        /* Alt on the timeout or completed channel */
        talt
        ldlp    MON_COMPLETED
        ldc     1
        enbc
        ldl     MON_TIME
        ldc     1
        enbt
        taltwt
        ldlp    MON_COMPLETED
        ldc     1
#ifdef _ICC
        ldc     completed - end
#endif
#ifdef __LCC__
        equ     @_3,completed-end
        ldc     @_3
#endif
        disc
        ldl     MON_TIME
        ldc     1
#ifdef _ICC
        ldc     timeout - end
#endif
#ifdef __LCC__
        equ     @_4,timeout-end
        ldc     @_4
#endif
        dist
        altend
LABEL(end)

LABEL(completed)
        ldlp    0       /* scratch */
        ldlp    MON_COMPLETED
        ldc     1
        in

        ldc     0
        stl     MON_RESULT

        /* Join with I/O process */
        ldlp    MON_ENDP_P
        endp

LABEL(timeout)
        ldl     MON_CHAN
        resetch
        stl     0       /* scratch */
        ldl     0
        mint
        diff
        CJ(not_running)
        ldl     0
        runp
LABEL(not_running)
        ldlp    0       /* scratch */
        ldlp    MON_COMPLETED
        ldc     1
        in

        ldc     1
        stl     MON_RESULT

        /* Join with I/O process */
        ldlp    MON_ENDP_P
        endp
