/* $Id: chan.c,v 1.2 1994/10/10 18:17:05 stuart Exp $ */

/* Written by Michael Haardt and Stuart Menefy, 1994 */

#include <transputer/channel.h>

#ifdef __LCC__
/*{{{  ChanIn*/
void ChanIn(channel_t *c, void *data, int count)
{
  asm(" ldl %data");
  asm(" ldl %c");
  asm(" ldl %count");
  asm(" in");
}
/*}}}  */
/*{{{  ChanInByte*/
int ChanInByte(channel_t *c)
{
  volatile char tmp;

  asm(" ldlp %tmp");
  asm(" ldl %c");
  asm(" ldc 1");
  asm(" in");
  return tmp;
}
/*}}}  */
/*{{{  ChanInInt32*/
long ChanInInt32(channel_t *c)
{
  volatile long n;

  asm(" ldl %n");
  asm(" ldl %c");
  asm(" ldc 4");
  asm(" in");
  return n;
}
/*}}}  */
/*{{{  ChanOut*/
void ChanOut(channel_t *c, const void *data, int count)
{
  asm(" ldl %data");
  asm(" ldl %c");
  asm(" ldl %count");
  asm(" out");
}
/*}}}  */
/*{{{  ChanOutByte*/
void ChanOutByte(channel_t *c, unsigned char val)
{
  asm(" ldlp %val");
  asm(" ldl %c");
  asm(" ldc 1");
  asm(" out");
}
/*}}}  */
/*{{{  ChanOutInt32*/
void ChanOutInt32(channel_t *c, long val)
{
  asm(" ldlp %val");
  asm(" ldl %c");
  asm(" ldc 4");
  asm(" out");
}
/*}}}  */
#endif
/*{{{  ChanInInt16*/
int ChanInInt16(channel_t *c)
{
  int val;

  val = 0;   /* Initialise MSBs */
  ChanIn(c, &val, 2);
  return val;
}
/*}}}  */
/*{{{  ChanOutInt16*/
void ChanOutInt16(channel_t *c, int data)
{
  ChanOut(c, &data, 2);
}
/*}}}  */
