/*{{{  Notes*/
/* Written by Michael Haardt, 1995                                  */
/* This is unportable, but nevertheless probably quite portable. :) */
/* Perhaps someone finds a better implementation.                   */
/*}}}  */
/*{{{  #defines*/
/* lcc version */
#ifdef __t414
#define LITTLE_ENDIAN
#endif
#ifdef __t800
#define LITTLE_ENDIAN
#endif
/* icc version */
#ifdef _ICC
#define LITTLE_ENDIAN
#endif
/*}}}  */

/*{{{  types*/
typedef union
{
  unsigned long int ul;
  signed char c[sizeof(unsigned long int)];
} ul;

typedef union
{
  unsigned short int us;
  signed char c[sizeof(unsigned short int)];
} us;
/*}}}  */

/*{{{  htonl -- host to network long*/
unsigned long int htonl(unsigned long int hostlong)
{
#ifdef LITTLE_ENDIAN
  ul n;

  n.ul=hostlong;
  return (((((n.c[0]<<8)|n.c[1])<<8)|n.c[2])<<8)|n.c[3];
#else
  return hostlong;
#endif
}
/*}}}  */
/*{{{  htons -- host to network short*/
unsigned short int htons(unsigned short int hostshort)
{
#ifdef LITTLE_ENDIAN
  us n;

  n.us=hostshort;
  return (n.c[0]<<8)|n.c[1];
#else
  return hostshort;
#endif
}
/*}}}  */
/*{{{  ntohl -- network to host long*/
unsigned long int ntohl(unsigned long int netlong)
{
#ifdef LITTLE_ENDIAN
  ul n;

  n.ul=netlong;
  return (((((n.c[0]<<8)|n.c[1])<<8)|n.c[2])<<8)|n.c[3];
#else
  return netlong;
#endif
}
/*}}}  */
/*{{{  ntohs -- network to host short*/
unsigned short int ntohs(unsigned short int netshort)
{
#ifdef LITTLE_ENDIAN
  us n;

  n.us=netshort;
  return (n.c[0]<<8)|n.c[1];
#else
  return netshort;
#endif
}
/*}}}  */
