/* $Id: _sigaction.c,v 1.1 1995/05/24 18:55:19 stuart Exp $ */

#include <lib.h>
#define sigaction _sigaction
#include <sys/sigcontext.h>
#include <signal.h>

_PROTOTYPE(int __sigreturn, (void));

PUBLIC int sigaction(int sig, const struct sigaction *act, struct sigaction *oact)
{
  message m;

#ifdef __LCC__
  /* XXX - POSIX violation */
  ((struct sigaction*)act)->sa_flags|=SA_NOGSB;
#endif
  m.m1_i2 = sig;

  /* XXX - yet more type puns because message struct is short of types. */
  m.m1_p1 = (char *) act;
  m.m1_p2 = (char *) oact;
  m.m1_p3 = (char *) __sigreturn;

  return(_syscall(MM, SIGACTION, &m));
}
