/* $Id: xdr_utmp.c,v 1.1 1995/05/24 18:53:29 stuart Exp $ */

/*

Written by Michael Haardt, 1995.

We have to watch out to use the right xdr types for pid_t and time_t
here, or you will get in trouble.  Then again, I don't know any system
where either pid_t or time_t could not be stored in 32 bits, so this
XDR definition should be fine.  Note that xdr_short, xdr_int and 
xdr_long can be exchanged here as your utmp declaration needs it,
because they all use the XDR 32 bit int type.

*/

#include <xdr/utmp.h>

bool_t xdr_utmp(XDR *xdrs, struct utmp *utmp)
{
  size_t ut_namesize=UT_NAMESIZE;
  void *ut_nameptr=&(utmp->ut_user);
  size_t ut_idsize=2;
  void *ut_idptr=&(utmp->ut_id);
  size_t ut_linesize=UT_LINESIZE;
  void *ut_lineptr=&(utmp->ut_line);
  size_t ut_hostsize=UT_HOSTSIZE;
  void *ut_hostptr=&(utmp->ut_host);

  return
  (
    xdr_bytes(xdrs,&ut_nameptr,&ut_namesize,UT_NAMESIZE)
    && xdr_bytes(xdrs,&ut_idptr,&ut_idsize,2)
    && xdr_bytes(xdrs,&ut_lineptr,&ut_linesize,UT_LINESIZE)
    && xdr_bytes(xdrs,&ut_hostptr,&ut_hostsize,UT_HOSTSIZE)
    && xdr_int(xdrs,&(utmp->ut_pid))
    && xdr_short(xdrs,&(utmp->ut_type))
    && xdr_u_long(xdrs,&(utmp->ut_time))
  );
}
