/* Written by Michael Haardt, 1994. */
/*{{{}}}*/
/*{{{  #includes*/
#include <sys/types.h>
#include <stdio.h>
#include <pwd.h>
#include <unistd.h>
/*}}}  */

/*{{{  putpwent*/
int putpwent(const struct passwd *pw, FILE *stream)
{
  char *p;

  p=pw->pw_name; while (*p) { fputc(*p,stream); ++p; }
  fprintf(stream,":%d:%d:",pw->pw_uid,pw->pw_gid);
  p=pw->pw_gecos; while (*p) { fputc(*p,stream); ++p; }
  fputc(':',stream);
  p=pw->pw_dir; while (*p) { fputc(*p,stream); ++p; }
  fprintf(stream,":%lu:%lu",pw->pw_maxage,pw->pw_expire);
  return (fputc('\n',stream)=='\n' ? 0 : -1);
}
/*}}}  */
/*{{{  putpwxent*/
int putpwxent(const struct passwd *pw, FILE *stream)
{
  char *p;

  p=pw->pw_passwd; while (*p) { fputc(*p,stream); ++p; }
  fputc(':',stream);
  p=pw->pw_shell; while (*p) { fputc(*p,stream); ++p; }
  return (fputc('\n',stream)=='\n' ? 0 : -1);
}
/*}}}  */
