#include <lib.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <mntent.h>

static struct mntent mt;	/* local mtab entry */
static char mde[] = " ";	/* delimiter */

struct mntent *getmntent(mf)
FILE *mf;
{
/* Read the next entry from the mtab file. The entry is parsed and returned
 * as a struct mntent. A static structure is returned. Return NULL on end
 * of file or error.
 */
  int c;
  char *p;
  static char line[128];

  while (fgets(line, sizeof line, mf) != NULL) {
	p = strchr(line, 0);
	if (p[-1] == '\n') {
		*--p = 0;
	} else {
		while ((c = getc(mf)) != 'n' && c != EOF)
			continue;
	}
	if (line[0] == '#') continue;
	if ((mt.mnt_fsname = strtok(line, mde)) != NULL &&
	    (mt.mnt_dir = strtok((char *) NULL, mde)) != NULL &&
	    (mt.mnt_type = strtok((char *) NULL, mde)) != NULL &&
	    (mt.mnt_opts = strtok((char *) NULL, mde)) != NULL)
		return &mt;
	break;
  }
  return NULL;
}


#if 0
static int writefield(fd, p, s)
int fd;
char *p;
char *s;
{
/* Write a mount database field entry followed by a delimiter */
  register unsigned int len;

  return ((len = strlen(p)) == 0 ||
          write(fd, p, len) <  0 ||
          write(fd, s, 1)   <  0) ? -1 : 0;
}
#endif


int addmntent(mf, mp)
FILE *mf;
struct mntent *mp;
{
/* Write the mount entry on to the end of the database. Return zero on
 * success, -1 on failure.
 */
  if (fseek(mf, (off_t) 0, SEEK_END) == EOF)
	return -1;

  fputs(mp->mnt_fsname, mf); putc(mde[0], mf);
  fputs(mp->mnt_dir,    mf); putc(mde[0], mf);
  fputs(mp->mnt_type,   mf); putc(mde[0], mf);
  fputs(mp->mnt_opts,   mf); putc(mde[0], mf); putc('\n', mf);
  fflush(mf);
  return ferror(mf);
}


char *hasmntopt(mp, opt)
struct mntent *mp;
char *opt;
{
/* Scan the mnt_opts field for an entry matching opt. Return its address
 * if found, otherwise return NULL.
 */
  char *s;
  char *p;
  unsigned int len;

  if ((s = mp->mnt_opts) == NULL || (len = strlen(opt)) == 0) return NULL;
  while (*s != 0 && (p = strstr(s, opt)) != NULL) {
	if ((p == mp->mnt_opts || p[-1] == ',') && (p[len] == ',' || p[len] == 0))
		return p;
	s = p + 1;
  }
  return NULL;
}
