/* $Id: libconf.c,v 1.1 1995/05/24 18:53:29 stuart Exp $ */

#include <minix/libconf.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <paths.h>

#define LINESIZE 80

static int initialised=0;

unsigned int _pwd_conf=0;
static const char *pwd_str[]={ "passwd", "traditional", "dotshadow" };

/*{{{  libconfopt*/
static void libconfopt(char *line, const char *str[], unsigned int size, unsigned int *conf)
{
  char *s;
  unsigned int i;

  while (*line==' ' || *line=='\t') ++line;
  if (*line=='#' || *line=='\0') return;
  s=line; while (*s && *s!=' ' && *s!='\t') ++s; if (*s) *s++='\0';
  if (strcmp(str[0],line)!=0) return;
  while (*s==' ' || *s=='\t') ++s;
  line=s; while (*s && *s!=' ' && *s!='\t') ++s; *s='\0';
  for (i=0; i<size-1; ++i)
  {
    if (strcmp(line,str[i+1])==0) { *conf=i; return; }
  }
}
/*}}}  */
/*{{{  _libconf*/
void _libconf(void)
{
  int fd;
  
  if (initialised==0)
  {
    if ((fd=open(_PATH_LIBCONF,O_RDONLY))>=0)
    {
      size_t cur;
      size_t size;
      char buf[1024];
      char ln[LINESIZE];

      cur=0;
      size=read(fd,buf,1024);
      while (size>0)
      {
        char c;
        size_t i;

        for (c='\0',i=0; c!='\n' && size>0; ++i)
        {
          c=buf[cur];
          if (i<LINESIZE-1) ln[i]=c;
          if (++cur==size) { size=read(fd,buf,1024); cur=0; }
        }
        --i; /* i got incremented before exiting the loop */
        ln[i<LINESIZE-1 ? i+(ln[i]!='\n') : LINESIZE-1]='\0';
        libconfopt(ln,pwd_str,sizeof(pwd_str)/sizeof(char*),&_pwd_conf);
      }
      close(fd);
    }
    initialised=1;
  }
}
/*}}}  */
