/* $Id: itoa.c,v 1.1 1995/05/24 18:53:29 stuart Exp $ */

#include <lib.h>
/* Integer to ASCII for signed decimal integers. */

#if _EM_WSIZE == 2
#define INT_MIN_CHARS "-32768"
#define MAX_DIVISOR     10000
#elif _EM_WSIZE == 4
#define INT_MIN_CHARS "-2147483648"
#define MAX_DIVISOR     1000000000
#else
#error "Unknown word size"
#endif

PRIVATE int next;
PRIVATE char qbuf[8];

_PROTOTYPE( char *itoa, (int n));

char *itoa(n)
int n;
{
  register int r, k;
  int flag = 0;

  next = 0;
  if (n < 0) {
	if (n == INT_MIN) {
		/* Prevent overflow when negating 2s-complement minimim int */
		return INT_MIN_CHARS;
	}

	qbuf[next++] = '-';
	n = -n;
  }
  if (n == 0) {
	qbuf[next++] = '0';
  } else {
	k = MAX_DIVISOR;
	while (k > 0) {
		r = n / k;
		if (flag || r > 0) {
			qbuf[next++] = '0' + r;
			flag = 1;
		}
		n -= r * k;
		k = k / 10;
	}
  }
  qbuf[next] = 0;
  return(qbuf);
}
