#include <minix/locale.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <locale.h>
#include <nl_types.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

/*{{{  catopen*/
nl_catd catopen(const char *file, int oflag)
{
  /*{{{  variables*/
  struct stat buf;
  char magic[6];
  size_t size,off;
  nl_catd catalog;
  int fd;
  /*}}}  */
  
  /*{{{  open file*/
  if ((fd=__opennls("LC_MESSAGES",setlocale(LC_MESSAGES,(char*)0),(char*)0,file))==-1) return (nl_catd)-1;
  /*}}}  */
  /*{{{  check magic number*/
  if (read(fd,magic,6)!=6 || strncmp(magic,"gencat",6) || fstat(fd,&buf)==-1 || (size=(size_t)buf.st_size)<8 || (catalog=malloc((size_t)(size-=6)))==(char*)0)
  {
    close(fd);
    return (nl_catd)-1;
  }
  /*}}}  */
  /*{{{  read catalog*/
  for (off=0; off<size; off+=8192)
  {
    size_t l;
  
    l=(off+8192<size ? 8192 : size-off);
    if (read(fd,catalog+off,l)!=l)
    {
      close(fd);
      return (nl_catd)-1;
    }
  }
  /*}}}  */
  close(fd);
  return catalog;
}
/*}}}  */
/*{{{  catclose*/
void catclose(nl_catd catd)
{
  if (catd!=(nl_catd)0 && catd!=(nl_catd)-1) free(catd);
}
/*}}}  */
/*{{{  catgets*/
const char *catgets(nl_catd catd, int setid, int msgid, const char *msg)
{
  char *base;
  int off;

  if (catd==(nl_catd)0 || catd==(nl_catd)-1 || ((*catd)|(*(catd+1)<<8))<setid) return msg;
  base=catd+2+(setid-1)*5;
  if (((*base)|(*(base+1)<<8))<msgid) return msg;
  base=catd+((*(base+2))|(*(base+3)<<8)|(*(base+4)<<16))+3*(msgid-1);
  off=((*base)|(*(base+1)<<8)|(*(base+2)<<16));
  return (off ? catd+off : msg);
}
/*}}}  */
