; $Id: allocafree.S,v 1.1 1995/06/21 18:51:24 stuart Exp $

; File  : allocafree.s
; Author: Stuart Menefy
; Date  : 29/12/92

; Revisions

; This code is 'returned to' at the end of any function which calls
; alloca(), and so will be called with the workspace pointer in the context
; of the calling function. On entry, A will hold the return value (if any)
; from the called function. Most of the hard work is done by the C function
; _alloca_helper() in alloca.c.
;
; The stack looks like this:
;
;  0 stack of calling function
; -1 saved CReg, which held the third function argument
; -2 saved BReg, which held the second function argument
; -3 saved AReg, which held the first function argument
; -4 return address, which must have been __alloca_free in case we are here

__alloca_free
        ajw     -4
        stl     1

; Stack now looks like
; 4 stack of calling function
; 3
; 2
; 1 return value of called function
; 0

        ldl     1
        call __alloca_helper

; This returns with the address to return to in A.
        stl     0
        ldl     1

; Use a ret to deallocate the workspace, and return (address in 0).
        ret
