;{{{  Notes
; This is the transputer version of the longjmp function.
; Note that this does restore the signal mask.
;}}}
;{{{  equs
     equ @val,2
     equ @env,1
     equ @IPtr,0

     equ @JB_MASK,1
     equ @JB_FLAGS,0
     equ @JB_IPTR,2
     equ @JB_WPTR,3
     equ @JB_A_PTR,4
     equ @JB_A_RETPTR,5
     equ @JB_A_RETADDR,6
     equ @SIG_BLOCK,0
     equ @SC_SIGCONTEXT,2
     equ @SC_NOREGLOCALS,4
     equ @SC_NOREGLOCALS_OR_SC_SIGCONTEXT,6
;}}}

_longjmp
;    Check that this is not supposed to set up a signal mask.
     ldl @env
     ldnl @JB_FLAGS
     eqc SC_NOREGLOCALS_OR_SC_SIGCONTEXT
     cj __longjerr

;    Read the value of _alloca_longjmp
     ldpi __alloca_longjmp
     stl @IPtr

;    If _alloca_jmp set, call it
     ldl @IPtr
     cj @longjmp_not_set

;    Simulate a call by setting up the stack manually
     ajw -4
;    env with decreased WPtr
     ldl 5
     ldnl @JB_A_PTR
     stl 1
     ldpi return
     stl 0
;    *_alloca_longjmp (was 0)
     ldl 4
     gcall
@return

;    Restore the return address
     ldl @env
     ldnl @JB_A_RETADDR
     ldl @env
     ldnl @JB_A_RETPTR
     stnl @IPtr

@longjmp_not_set
;    Set up return value
     ldl @val
     eqc 0
     cj @non_zero
     ldc 1
     stl @val
@non_zero
;    Jmp into sigjmp to restore the value.
     j __sigjmp
