;{{{}}}
;{{{  Notes
; This is the transputer version of the _setjmp function.
;
; All setjmp versions arrive here:
;   setjmp(env, 1, params)
;   _setjmp(env, 0, params)
;   sigsetjmp(env, savemask, params)

; Save the current execution state in env.
; On entry:
;   3  params
;   2  savemask
;   1  env
;   0  Iptr
; Just save the return Iptr and Wptr, as registers not preserved
; across fn calls.
;}}}
;{{{  equs
     equ @IPtr,0
     equ @env,1
     equ @savemask,2
     equ @params,3

     equ @JB_MASK,1
     equ @JB_FLAGS,0
     equ @JB_IPTR,2
     equ @JB_WPTR,3
     equ @JB_A_PTR,4
     equ @JB_A_RETPTR,5
     equ @JB_A_RETADDR,6
     equ @SIG_BLOCK,0
     equ @SC_SIGCONTEXT,2
     equ @SC_NOREGLOCALS,4
;}}}

__setjmp
     ldl @savemask
     cj @dont_save

;    Call sigprocmask(how, set, oset) to determine the current mask
     ajw -1

;    ldl @env, but with decreased WPtr
     ldl 2
     ldnlp @JB_MASK

;    oset (&env->__mask)
     stl 0

;    set (NULL pointer)
     ldc 0

;    how (dummy value as set is NULL)
     ldc @SIG_BLOCK  -- how (dummy value as set is NULL)
     call _sigprocmask
     ajw 1
     ldc @SC_SIGCONTEXT

@dont_save
;    Note this must have the signal mask in A. We are able to
;    take advantage of cj leaving 0 in A for once!

;    Set up env->__flags
     adc @SC_NOREGLOCALS
     ldl @env
     stnl @JB_FLAGS

;    Set up env->__pc
     ldl @IPtr
     ldl @env
     stnl @JB_IPTR

;    Set up env->__sp
     ldlp 0
     ldl @env
     stnl @JB_WPTR

;    Store the information needed to undo any calls to alloca().
;    The alloca pointer is saved so we can free any blocks allocated
;    between the setjmp() and the longjmp(). Similarly we have to save
;    the return address in case it gets altered later in the function,
;    and the params pointer is needed so we know where to restore it.
     ldpi _alloca_last
     ldl @env
     stnl @JB_A_PTR

     ldl @params
     ldl @env
     stnl @JB_A_RETPTR

     ldl @params
     ldnl 0
     ldl @env
     stnl @JB_A_RETADDR

     ldc 0
     ret
