;{{{}}}
;{{{  Notes
; This is the transputer version of the _longjmp function.
; Note that this does NOT restore the signal mask.

; Restore the execution state in env.
; On entry:
;   2  val
;   1  env
;   0  Iptr
; Restore the stack pointer and return address, calculate the return value,
; and then do a return.
;
; Take care with return value, as if this is 0, we actually return 1!
;}}}
;{{{  equs
     equ @val,2
     equ @env,1
     equ @IPtr,0
     equ @JB_MASK,1
     equ @JB_FLAGS,0
     equ @JB_IPTR,2
     equ @JB_WPTR,3
     equ @JB_A_PTR,4
     equ @JB_A_RETPTR,5
     equ @JB_A_RETADDR,6
     equ @SIG_BLOCK,0
     equ @SC_SIGCONTEXT,2
     equ @SC_NOREGLOCALS,4
;}}}

__longjmp
;    Check that this is not supposed to set up a signal mask.
     ldl @env
     ldnl JB_FLAGS
     eqc SC_NOREGLOCALS
     cj __longjerr

;    Read the value of _alloca_longjmp
     ldpi __alloca_longjmp
     stl 0

;    If _alloca_jmp set, call it
     ldl 0
     cj @longjmp_not_set

;    Simulate a call by setting up the stack manually
     ajw -4
;    ldl @env with decreased WPtr
     ldl 5
     ldnl @JB_A_PTR
     stl 1
     ldpi @return
     stl 0
;    *_alloca_longjmp (was 0)
     ldl 4
     gcall
@return

;    Restore the return address
     ldl @env
     ldnl @JB_A_RETADDR
     ldl @env
     ldnl @JB_A_RETPTR
     stnl 0

@longjmp_not_set
;    Set up return Iptr
     ldl @env
     ldnl @JB_IPTR
     ldl @env
     ldnl @JB_WPTR
     stnl 0

;    Set up return value
     ldl @val
     eqc 0
     cj @non_zero
     ldc 1
     stl @val
non_zero
     ldl @val
     ldl @env
     ldnl @JB_WPTR
     stnl 1

;    Now restore stack and return
     ldl @env
     ldnl @JB_WPTR
     gajw
     ldl 1
     ret
