-- $Id: initstatic.s,v 1.2 1994/10/10 18:39:43 stuart Exp $

-- This file contains code to support the initialisation of static areas.
--
-- Modifications:
--   08/04/91 SIM Created
--   17/04/91 SIM Added code to zero area, and return stack pointer
--   08/05/91 SIM Modified for general use.
-- 

-- This will initialise the static area by calling the relevant routines
-- On entry the first parameter must contain the address of the base of the
-- static area, and the second is the address of the swiChannel.
-- There is an optional third parameter which is passed to the static
-- initialisation routine, but which is only used for FS. 
-- There must be a minimal amount of workspace available.
-- It will return with the new value of the stack pointer in A.

-- Workspace usage:
--  4  _swiChannelPtr
--  3  gsb
--  2  return Iptr
--  1  loopEnd
--  0  loopValue / static init code pointer

init.static:
        global init.static

        ajw     -2
        
        -- Initialise the static area to 0's
        ldc     0
        stl     0       -- loopValue

        patch   8 ldc limit
        blkb    8, #20, #20, #20, #20, #20, #20, #20, #20
        stl     1       -- loopEnd
zloop:
        ldc     0
        ldl     0       -- loopValue
        ldl     3       -- gsb
        wsub
        stnl    0       
        ldlp    0
        ldc     (zloopend - zloop)
        lend
zloopend:

        -- Set up the global static
        ldc     (staticstart - ilabel1)
        ldpi
ilabel1:
        stl     0       -- codePtr
iloop:
        ldl     0       -- codePtr
        ldnl    0
        cj      finished

        ldl     0       -- codePtr
        ldl     0       -- codePtr
        ldnl    0
        sum
        stl     0       -- codePtr

        ldl     3       -- gsb
        call    indirectCall
        j       iloop

finished:

        -- Initialise the _swiChannelPtr
        ldl     4       -- _swiChannelPtr
        ldl     3       -- gsb
        patch   3 ldnl modnumber
        byte    #20, #20, #20
        stnl    0       -- offset of _swiChannelPtr in static data

        ajw   2
        ret

-- Indirect call, the calling code has just pushed 3 words plus return Iptr
indirectCall:
        ldl     4       -- codePtr (was 0)
        ldnlp   1       -- Word after is start of code
        gcall

-- The linker will patch in here the the offset of the first static
-- initialisation routine from the start of the code.
        align
staticstart:
        maininit blkb 4, #20, #20, #20, #20

-- This is this modules static data.
-- This is a location which will hold the _swiChannelPtr
        global  _swiChannelPtr
        data    _swiChannelPtr 1


-- Make this module part of the static chain
        init
        byte    #20, #20, #20, #20

-- The code to perform the initialisation
        ajw     -1

        -- Find  the address of the lsb
        ldl     2       -- gsb
        patch   6 ldnlp staticfix
        byte    #20, #20, #20, #20, #20, #20
        stl     0       -- lsb

        -- Store the address of the lsb in the table at the start
        ldl     0       -- lsb
        ldl     2       -- gsb
        patch   3 stnl modnumber
        byte    #20, #20, #20
        
        ajw     1
        ret

