-- $Id: cstart.s,v 1.2 1994/10/10 18:39:43 stuart Exp $

-- This is the entry point for the commands. It is called when the command
-- is first run, and first initialises the static, then
-- jumps into the main code.

-- On entry, workspace is normal minix start up, but with two additional
-- words of transputer specific data:
--      ... environment strings ...
--      ... argument strings ...
--      ... environment pointers (NULL terminated) ...
--   3  ... argument pointers (NULL terminated) ...
--   2  nargs
--   1  _swiChannelPtr
--   0  gsb
-- Note, there is no return address.
--
-- This will be converted into a form suitable for a call to main:
--         ... environment strings ...
--         ... argument strings ...
--         ... environment pointers (NULL terminated) ...
--   3     ... argument pointers (NULL terminated) ...
--   2     nargs
--   1     gsb copy
--   0     envp
--   C     argv
--   B     nargs
--   A     gsb
--
-- The nargs at 2 is not used, but must be present for ps to find the
-- arguments correctly (it also makes the code shorter!).

_cstart%up:
        global  _cstart%up

        -- Allocate some space to work in:
        --   1 local systask
        --   0 lsb
        ajw     -2
        stl     1

        -- Call the static initialisation code
        ldl     3       -- _swiChannelPtr (was 1)
        ldl     2       -- gsb (was 0)
        extern  init.static
        patch   6 call codefix init.static 0
        byte    #20, #20, #20, #20, #20, #20

        -- Calculate the lsb
        ldl     2       -- gsb (was 0)
        patch   3 ldnl modnumber
        byte    #20, #20, #20
        stl     0       -- lsb

        -- Set up current top of data
        patch   6 ldc limit
        byte    #20, #20, #20, #20, #20, #20
        ldl     2       -- gsb (was 0)
        wsub
        ldl     0       -- lsb
        extern  _brksize
        patch   6 stnl datafix _brksize 0
        byte    #20, #20, #20, #20, #20, #20
        
        -- Store the copy of the gsb
        ldl     2       -- gsb (was 0)
        stl     3       -- gsb copy (was 1)
        
        -- Calculate environment pointer
        ldl     4       -- nargs (was 2)
        ldlp    6       -- Really want 5 (was 3), but add 1 because of NULL in argv list
        wsub
        stl     2       -- env pointer (was 0) (4th parameter for call to main)

	-- Store the environment pointer to _penvp
	ldl     2       -- env pointer (was 0)
        ldl     0       -- lsb
	extern _penvp
        patch   6 stnl datafix _penvp 0
        byte    #20, #20, #20, #20, #20, #20
	
        -- Decide whether to store environment pointer into environ static
        -- variable, or is it a user defined variable?
        ldl     0       -- lsb
        extern  environ
        patch   6 ldnl datafix environ 0
        byte    #20, #20, #20, #20, #20, #20
        eqc     #53535353
        cj      user_environ
        
        ldl     2       -- env pointer (was 0)
        ldl     0       -- lsb
        patch   6 stnl datafix environ 0
        byte    #20, #20, #20, #20, #20, #20
user_environ:        

        -- Store the local systask number
        ldl     1       -- systask number
        ldl     0       -- lsb
        extern  _local_systask
        patch   6 stnl datafix _local_systask 0
        byte    #20, #20, #20, #20, #20, #20

        -- Set up stack and call
        ajw     2
        ldlp    3       -- argv pointer
        ldl     2       -- nargs
        ldl     1       -- gsb

        extern  main
        patch   6 call codefix main  0
        byte    #20, #20, #20, #20, #20, #20

        -- If main returns, call exit with exit value in stack
        ldl     1       -- gsb

        extern  exit
        patch   6 call codefix exit 0
        byte    #20, #20, #20, #20, #20, #20
        
        -- This code should never be executed
        seterr

        align

-- Exported variables
        global  _local_systask
        data    _local_systask 1
        global  _penvp
        data    _penvp 1
        
-- Make this module part of the static chain
        init
        byte    #20, #20, #20, #20

-- The code to perform the initialisation
        ajw     -1

        -- Find  the address of the lsb
        ldl     2       -- gsb
        patch   6 ldnlp staticfix
        byte    #20, #20, #20, #20, #20, #20
        stl     0       -- lsb

        -- Store the address of the lsb in the table at the start
        ldl     0       -- lsb
        ldl     2       -- gsb
        patch   3 stnl modnumber
        byte    #20, #20, #20

        ajw     1
        ret
