-- $Id: allocafree.s,v 1.1 1994/06/03 20:14:32 stuart Exp $

-- File  : allocafree.s
-- Author: Stuart Menefy
-- Date  : 29/12/92
--
-- Revisions:

-- This code is 'returned to' at the end of any function which calls
-- alloca(), and so will be called with the workspace pointer in the context
-- of the calling function. On entry, A will hold the return value (if any)
-- from the called function. Most of the hard work is done by the C function
-- _alloca_helper() in alloca.c.

_alloca_free:
        global _alloca_free

        ajw     -4      -- Make this look like a real function call
        stl     2       -- Store the return value

        -- Stack now looks like:
        --  4 ... stack of calling function
        --  3
        --  2 return value
        --  1 GSB
        --  0

        ldl     1       -- gsb
        extern _alloca_helper
        patch 6 call codefix _alloca_helper 0
        byte    #20, #20, #20, #20, #20, #20

        -- This returns with the address to return to in A.
        stl     0       -- return address
        ldl     2       -- return value

        -- Use a ret to deallocate the workspace, and return (address in 0).
        ret     
