-- $Id: _setjmp.S,v 1.1 1994/06/03 20:14:32 stuart Exp $

-- This is the transputer version of the _setjmp function.
--
-- All setjmp versions arrive here:
--   setjmp(env, 1, params)
--   _setjmp(env, 0, params)
--   sigsetjmp(env, savemask, params)
--
-- Created  21/5/91 by SIM
-- Modified:
--   08/05/94  SIM  Added 1.6.25 functionality
--   26/05/94  SIM  Folded setjmp and _setjmp into this one file to overcome
--                  problem of icc only recognising _setjmp().
--

#include <minix/config.h>
#include <minix/jmp_buf.h>

-- Save the current execution state in env.
-- On entry:
--   4  params
--   3  savemask
--   2  env
--   1  gsb
--   0  Iptr
-- Just save the return Iptr and Wptr, as registers not preserved
-- across fn calls.
_setjmp:
        global  _setjmp

        ldl     3       -- savemask
        cj      dont_save

        -- Call sigprocmask(how, set, oset) to determine the current mask
        ajw     -1
        ldl     3       -- env (was 2)
        ldnlp   JB_MASK
        stl     0       -- oset (&env->__mask)
        ldc     0       -- set (NULL pointer)
        ldc     SIG_BLOCK  -- how (dummy value as set is NULL)
        ldl     2       -- gsb (was 1)
        extern _sigprocmask
        patch 6 call codefix _sigprocmask 0
	blkb  6
        ajw     1

        ldc     SC_SIGCONTEXT
dont_save:
        -- Note this must have the signal mask in A. We are able to
        -- take advantage of cj leaving 0 in A for once!
        
	-- Set up env->__flags
        adc     SC_NOREGLOCALS
        ldl     2       -- env
        stnl    JB_FLAGS

        -- Set up env->__pc
        ldl     0       -- Return Iptr
        ldl     2       -- env
        stnl    JB_IPTR

        -- Set up env->__sp
        ldlp    0       -- Wptr
        ldl     2       -- env
        stnl    JB_WPTR

        -- Store the information needed to undo any calls to alloca().
        -- The alloca pointer is saved so we can free any blocks allocated
        -- between the setjmp() and the longjmp(). Similarly we have to save
        -- the return address in case it gets altered later in the function,
        -- and the params pointer is needed so we know where to restore it.
        ldl     1       -- gsb
        patch   3 ldnl modnumber
        byte    #20, #20, #20
        extern	_alloca_last
        patch   6 ldnl datafix _alloca_last 0
        byte    #20, #20, #20, #20, #20, #20
        ldl     2       -- env
        stnl    JB_A_PTR

        ldl     4       -- params
        ldl     2       -- env
        stnl    JB_A_RETPTR

        ldl     4       -- params
        ldnl    0       -- return address
        ldl     2       -- env
        stnl    JB_A_RETADDR

        ldc     0       -- return value (must be 0)
        ret

-- Make this module part of the static chain
	align
        init
        byte    #20, #20, #20, #20

-- The code to perform the initialisation
        -- Find  the address of the lsb
        ldl     1       -- gsb
        patch   6 ldnlp staticfix
        byte    #20, #20, #20, #20, #20, #20

        -- Store the address of the lsb in the table at the start of the gsb
        ldl     1       -- gsb
        patch   3 stnl modnumber
        byte    #20, #20, #20

        ret
