-- $Id: _longjmp.S,v 1.1 1994/06/03 20:14:32 stuart Exp $

-- This is the transputer version of the _longjmp function.
-- Note that this does NOT restore the signal mask.
--
-- Created  21/5/91 by SIM
-- Modified:
--   08/05/94  SIM  Added 1.6.25 functionality
--

#include <minix/config.h>
#include <minix/jmp_buf.h>

-- Restore the execution state in env.
-- On entry:
--   3  val
--   2  env
--   1  gsb
--   0  Iptr
-- Restore the stack pointer and return address, calculate the return value,
-- and then do a return. 
--
-- Take care with return value, as if this is 0, we actually return 1!

_longjmp:
        global  _longjmp

	-- Check that this is not supposed to set up a signal mask.
	ldl	2	-- env
	ldnl	JB_FLAGS
	eqc	SC_NOREGLOCALS
	cj	error

        -- Read the value of _alloca_longjmp
        ldl     1       -- gsb
        patch   3 ldnl modnumber
        byte    #20, #20, #20
        extern	_alloca_longjmp        
        patch   6 ldnl datafix _alloca_longjmp 0
        byte    #20, #20, #20, #20, #20, #20
        stl	0

        -- If _alloca_jmp set, call it
        ldl     0
        cj      longjmp_not_set

        -- Simulate a call by setting up the stack manually
        ajw	-4
        ldl     6       -- env (was 2)
        ldnl    JB_A_PTR
        stl     2
        ldl     5       -- gsb (was 1)
        stl     1
        ldc     (return - ilabel1)
        ldpi
ilabel1:
        stl     0
        ldl     4       -- *_alloca_longjmp (was 0)
        gcall
return:

        -- Restore the return address
        ldl     2       -- env
        ldnl    JB_A_RETADDR
        ldl     2       -- env
        ldnl    JB_A_RETPTR
        stnl    0       -- return address

longjmp_not_set:

        -- Set up return Iptr
        ldl     2       -- env
        ldnl    JB_IPTR
        ldl     2       -- env
        ldnl    JB_WPTR
        stnl    0       -- Store return address

        -- Set up return value
        ldl     3       -- val
        eqc     0
        cj      non_zero
        ldc     1
        stl     3       -- val
non_zero:
        ldl     3       -- val
        ldl     2       -- env
        ldnl    JB_WPTR
        stnl    1       -- return value

        -- Now restore stack and return
        ldl     2       -- env
        ldnl    JB_WPTR
        gajw
        ldl     1       -- return value
        ret

	-- jmp_buf was not generated by a call to _setjmp().
error:
        extern _longjerr
        patch 6 j codefix _longjerr 0
	blkb  6

-- Make this module part of the static chain
	align
        init
        byte    #20, #20, #20, #20

-- The code to perform the initialisation
        -- Find  the address of the lsb
        ldl     1       -- gsb
        patch   6 ldnlp staticfix
        byte    #20, #20, #20, #20, #20, #20

        -- Store the address of the lsb in the table at the start of the gsb
        ldl     1       -- gsb
        patch   3 stnl modnumber
        byte    #20, #20, #20

        ret
