/* $Id: allocaptrs.c,v 1.1 1994/06/03 20:14:32 stuart Exp $ */

/*
 * These are two pointers used by alloca() and the associated cleanup
 * functions. This technique is used so that no more code than is necessary
 * is pulled in when linking, as both these pointers are shared by alloca
 * and setjmp code.
 *
 * _alloca_last
 *   This is a pointer to the last block allocated by alloca().
 * _alloca_longjmp
 *   This is a pointer to a function which longjmp() can call if it is not
 *   NULL, and which will free any memory allocated by alloca().
 */

void* _alloca_last    = 0;
void* _alloca_longjmp = 0;
