; Written by Stuart Menefy and Michael Haardt, 1994.
;
; This is the entry point for the commands.
;
; On entry, workspace is normal minix start up, but with two additional
; words of transputer specific data:
;      ... environment strings ...
;      ... argument strings ...
;      ... environment pointers (NULL terminated) ...
;   3  ... argument pointers (NULL terminated) ...
;   2  argc
;   1  swiChannelPtr
;   0  gsb
; Note, there is no return address.
;
; This will be converted into a form suitable for a call to main (this is
; just before the call):
;         ... environment strings ...
;         ... argument strings ...
;         ... environment pointers (NULL terminated) ...
;   1     ... argument pointers (NULL terminated) ...
;   0     argc
;   C     envp
;   B     argv
;   A     argc
;
; The argc at 0 is not used, but must be present for ps to find the
; arguments correctly.

; Save local systask
        ldpi __local_systask
        stnl 0

; Save the software interrupt channel pointer
        ldl 1
        ldpi __swiChannelPtr
        stnl 0

; Calculate environment pointer
        ldl 2
        ldlp 4
        wsub
        stl 0

; Decide whether to store environment pointer in _environ variable or
; if it is a user defined variable.
        ldpi _environ
        ldnl 0
        eqc 0x53535353
        cj @user_environ
; Store environment pointer in _environ
        ldl 0
        ldpi _environ
        stnl 0
@user_environ
        ldl 0
        ldpi _penvp
        stnl 0
; Set up stack
        ldl 0
        ldlp 3
        ldl 2

; Adjust WPtr
        ajw 2

; Go!
        call _main

; If main returns, call exit with exit value in stack
        call __exit
        
; This code should never be executed
        seterr

; Where _environ is stored
        align
__swiChannelPtr
        d32 0
__brksize
        reloc
        d32 end
__local_systask
        d32 0
__penvp
        d32 0

