/*{{{}}}*/
/*{{{  #includes*/
#define _LIBRARY
#include <chan.h>
/*}}}  */

/*{{{  chan_out_byte*/
void chan_out_byte(char c, CHAN *chan)
{
  asm(" ldlp %c");
  asm(" ldl %chan");
  asm(" ldc 1");
  asm(" out");
}
/*}}}  */
/*{{{  chan_out_word*/
void chan_out_word(int n, CHAN *chan)
{
  asm(" ldlp %n");
  asm(" ldl %chan");
  asm(" ldc 4");
  asm(" out");
}
/*}}}  */
/*{{{  chan_out_message*/
void chan_out_message(int len, char *message, CHAN *chan)
{
  asm(" ldl %message");
  asm(" ldl %chan");
  asm(" ldl %len");
  asm(" out");
}
/*}}}  */

/*{{{  chan_in_byte*/
void chan_in_byte(char *c, CHAN *chan)
{
  char tmp;

  asm(" ldlp %tmp");
  asm(" ldl %chan");
  asm(" ldc 1");
  asm(" in");
  *c=tmp;
}
/*}}}  */
/*{{{  chan_in_word*/
void chan_in_word(int *n, CHAN *chan)
{
  asm(" ldl %n");
  asm(" ldl %chan");
  asm(" ldc 4");
  asm(" in");
}
/*}}}  */
/*{{{  chan_in_message*/
void chan_in_message(int len, char *message, CHAN *chan)
{
  asm(" ldl %message");
  asm(" ldl %chan");
  asm(" ldl %len");
  asm(" in");
}
/*}}}  */
