#define write _write
/*{{{}}}*/
/*{{{  #includes*/
#include "lib.h"

#include <unistd.h>
#include <string.h>
/*}}}  */

/*{{{  write*/
ssize_t write(int fd, const void *buffer, size_t len)
{
  /* aligned */ unsigned char message[1040];
  int l;

  if (fd<0 || fd>=_POSIX_OPEN_MAX || !__fileused[__fileptr[fd]])
  {
    errno=EINVAL;
    return -1;
  }

  if (len>1024) len=1024;
  l=len+7; if (l&1) l++;

  chan_out_message(2,(char*)&l,Link0Output);

  message[0]=__FPUTBLOCK;
  memcpy(&message[1],&__filedesc[__fileptr[fd]],4);
  memcpy(&message[5],&len,2);
  memcpy(&message[7],buffer,len);
  chan_out_message(l,(char*)message,Link0Output);

  chan_in_message(2,(char*)message,Link0Input);
  chan_in_message(4,(char*)message,Link0Input);

  errno=message[0];
  return (errno==EOK ? message[1]|(message[2]<<8) : -1);
}
/*}}}  */
