#define unlink _unlink
/*{{{}}}*/
/*{{{  #includes*/
#include "lib.h"

#include <fcntl.h>
#include <unistd.h>
#include <string.h>
/*}}}  */

/*{{{  unlink*/
int unlink(const char *file_name)
{
  /* aligned */ char message[1040];
  int l,namlen,imode,fd;

  namlen=strlen(file_name);
  l=namlen+3; if (l&1) l++;

  memcpy(&message[0],&l,2);
  chan_out_message(2,message,Link0Output);

  message[0]=__REMOVE;
  memcpy(&message[1],&namlen,2);
  memcpy(&message[3],file_name,namlen);
  chan_out_message(l,message,Link0Output);

  chan_in_message(2,message,Link0Input);
  chan_in_message(message[0]|(message[1]<<8),message,Link0Input);
  return ((errno=message[0])==EOK ? 0 : -1);
}
/*}}}  */
