#define read _read
/*{{{}}}*/
/*{{{  #includes*/
#include "lib.h"

#include <unistd.h>
#include <string.h>
/*}}}  */

/*{{{  read*/
ssize_t read(int fd, void *buffer, size_t len)
{
  /* aligned */ unsigned char message[1040];
  int l,clen,i;

  if (fd<0 || fd>=_POSIX_OPEN_MAX || !__fileused[__fileptr[fd]])
  {
    errno=EINVAL;
    return -1;
  }

  if (isatty(fd)==1 && len>1) len=1;

  for (i=0; i<=(len ? (len-1)/1024 : 0); i+=1024)
  {
    clen=((len-i) > 1024 ? 1024 : len-i);
    l=8;
    chan_out_message(2,(char*)&l,Link0Output);

    message[0]=__FGETBLOCK;
    memcpy(&message[1],&__filedesc[__fileptr[fd]],4);
    memcpy(&message[5],&clen,2);
    chan_out_message(l,(char*)message,Link0Output);

    chan_in_message(2,(char*)message,Link0Input);
    chan_in_message(message[0]|(message[1]<<8),(char*)message,Link0Input);

    errno=message[0];
    memcpy((void*)((char*)buffer+i),&message[3],message[1]|(message[2]<<8));
    if (errno!=EOK || (message[1]|(message[2]<<8))!=clen) { i+=1024; break; }
  }
  return (errno==EOK ? i-1024+(message[1]|(message[2]<<8)) : -1);
}
/*}}}  */
