#define open _open
/*{{{}}}*/
/*{{{  #includes*/
#include "lib.h"

#include <chan.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
/*}}}  */

/*{{{  open*/
int open(const char *file_name, int flag, ...)
{
  char message[1040];
  CHAN *ochan;
  CHAN *ichan;
  int l,namlen,imode,fd,ptr;

  for (fd=1; fd<(_POSIX_OPEN_MAX+1) && __fileused[fd]; fd++);
  for (ptr=0; fd<_POSIX_OPEN_MAX && __fileptr[ptr]!=-1; ptr++);
  if (ptr==_POSIX_OPEN_MAX || fd==_POSIX_OPEN_MAX) { errno=ENFILE; return -1; }
  switch (flag)
  {
    case O_RDONLY: imode=1; break;
    case O_WRONLY|O_CREAT:
    case O_WRONLY|O_CREAT|O_TRUNC: imode=2; break;
    case O_WRONLY|O_CREAT|O_APPEND: imode=3; break;
    case O_RDWR: imode=4; break;
    case O_RDWR|O_CREAT:
    case O_RDWR|O_CREAT|O_TRUNC: imode=5; break;
    case O_RDWR|O_CREAT|O_APPEND: imode=6; break;
    default: errno=EINVAL; return -1;
  }
  namlen=strlen(file_name);
  l=namlen+5; if (l&1) l++;

  ochan=(CHAN*)Link0Output;
  ichan=(CHAN*)Link0Input;

  memcpy(&message[0],&l,2);
  chan_out_message(2,message,ochan);

  message[0]=__FOPEN;
  memcpy(&message[1],&namlen,2);
  memcpy(&message[3],file_name,namlen);
  message[3+namlen]=1;
  message[4+namlen]=imode;
  chan_out_message(l,message,ochan);

  chan_in_message(2,message,ichan);
  chan_in_message(message[0]+(message[1]<<8),message,ichan);
  errno=message[0];
  if (errno==EOK)
  {
    memcpy(&__filedesc[fd],&message[1],4);
    __fileused[fd]=1;
    __fileptr[ptr]=fd;
    __isatty[fd]=-1;
    return ptr;
  }
  else return -1;
}
/*}}}  */
