#define lseek _lseek
/*{{{}}}*/
/*{{{  #includes*/
#include "lib.h"

#include <unistd.h>
/*}}}  */

/*{{{  lseek*/
off_t lseek(int fd, off_t offset, int whence)
{
  /*{{{  variables*/
  /* aligned */ char message[1040];
  int l;
  /*}}}  */

  if (fd<0 || fd>=_POSIX_OPEN_MAX || !__fileused[__fileptr[fd]])
  {
    errno=EINVAL;
    return -1;
  }

  l=14;
  chan_out_message(2,(char*)&l,Link0Output);

  message[0]=__FSEEK;
  memcpy(&message[1],&__filedesc[__fileptr[fd]],4);
  memcpy(&message[5],&offset,4);
  ++whence;
  memcpy(&message[9],&whence,4);
  chan_out_message(l,(char*)message,Link0Output);

  chan_in_message(2,(char*)message,Link0Input);
  chan_in_message(message[0]|(message[1]<<8),(char*)message,Link0Input);

  errno=message[0];
  if (errno!=EOK) return (-1);

  l=6;
  chan_out_message(2,(char*)&l,Link0Output);

  message[0]=__FTELL;
  memcpy(&message[1],&__filedesc[__fileptr[fd]],4);
  chan_out_message(l,(char*)message,Link0Output);

  chan_in_message(2,(char*)message,Link0Input);
  chan_in_message(message[0]|(message[1]<<8),(char*)message,Link0Input);

  memcpy(&l,&message[1],4);

  errno=message[0];
  return(errno==EOK ? l : -1);
}
/*}}}  */
