#define isatty _isatty
/*{{{}}}*/
/*{{{  #includes*/
#include "lib.h"

#include <fcntl.h>
#include <string.h>
#include <unistd.h>
/*}}}  */

/*{{{  isatty*/
int isatty(int fd)
{
  /* aligned */ char message[1040];
  int l;

  if (fd<0 || fd>=_POSIX_OPEN_MAX || !__fileused[__fileptr[fd]])
  {
    errno=EINVAL;
    return -1;
  }

  if (__isatty[__fileptr[fd]]>=0) return (__isatty[__fileptr[fd]]);

  l=6;
  memcpy(&message[0],&l,2);
  chan_out_message(2,message,Link0Output);

  message[0]=__ISATTY;
  memcpy(&message[1],&__filedesc[__fileptr[fd]],4);
  chan_out_message(l,message,Link0Output);

  chan_in_message(2,message,Link0Input);
  chan_in_message(message[0]|(message[1]<<8),message,Link0Input);
  errno=message[0];
  if (errno==EOK)
  {
    __isatty[__fileptr[fd]]=(message[1] ? 1 : 0);
    return (message[1] ? 1 : 0);
  }
  else
  {
    __isatty[__fileptr[fd]]=0;
    return 0;
  }
}
/*}}}  */
