#define dup2 _dup2
/*{{{}}}*/
/*{{{  #includes*/
#include "lib.h"

#include <errno.h>
#include <unistd.h>
/*}}}  */

/*{{{  dup2*/
int dup2(int old, int new)
{
  if (old<0 || old>=_POSIX_OPEN_MAX || !__fileused[__fileptr[old]])
  {
    errno=EINVAL;
    return -1;
  }
  _close(new);
  ++__fileused[__fileptr[old]];
  __fileptr[new]=__fileptr[old];
  return new;
}
/*}}}  */
