#define close _close
/*{{{  #includes*/
#include "lib.h"

#include <fcntl.h>
#include <string.h>
#include <unistd.h>
/*}}}  */

/*{{{  close*/
int close(int fd)
{
  /* aligned */ char message[1040];
  CHAN *ochan;
  CHAN *ichan;
  int l;

  if (fd<0 || fd>=_POSIX_OPEN_MAX || !__fileused[__fileptr[fd]])
  {
    errno=EINVAL;
    return -1;
  }
  __isatty[__fileptr[fd]]=-1;
  if (--__fileused[__fileptr[fd]])
  {
    errno=EOK;
    return 0;
  }
  else
  {
    ochan=(CHAN*)Link0Output;
    ichan=(CHAN*)Link0Input;

    l=6;
    memcpy(&message[0],&l,2);
    chan_out_message(2,message,ochan);

    message[0]=__FCLOSE;
    memcpy(&message[1],&__filedesc[__fileptr[fd]],4);
    chan_out_message(l,message,ochan);

    chan_in_message(2,message,ichan);
    chan_in_message(2,message,ichan);
    errno=message[0];
    return (errno==EOK ? 0 : -1);
  }
}
/*}}}  */
