#define brk _brk
#define sbrk _sbrk
/*{{{  #includes*/
#include <sys/types.h>
#include <errno.h>
/*}}}  */

/*{{{  variables*/
extern char *__end;
char *__MemEnd;
/*}}}  */

/*{{{  brk*/
int brk(void *end_data_segment)
{
  if ((long int)end_data_segment<=(long int)&end_data_segment-64) { __MemEnd=end_data_segment; return 0; }
  else { errno=ENOMEM; return -1; }
}
/*}}}  */
/*{{{  sbrk*/
void *sbrk(/* ptrdiff_t */ int increment)
{
  if (((int)(__MemEnd+increment))<=((int)&increment)-64) { __MemEnd+=increment; return (__MemEnd-increment); }
  else { errno=ENOMEM; return (void*)0; }
}
/*}}}  */
