/* Small fread test */
#include <stdio.h>

char buf[64];

int main()
{
  FILE *fp;
  register char ch;
  register int i;

  if ((fp = tmpfile()) == NULL) {
    fprintf(stderr, "Cannot open temporary file\n");
    exit(1);
  }

  ch = 1;
  for (i = 0; i < 10000; i++) {
    putc(ch, fp); putc(ch, fp); putc(ch, fp); putc(ch, fp);
    putc(ch, fp); putc(ch, fp); putc(ch, fp); putc(ch, fp);
    putc(ch, fp); putc(ch, fp); putc(ch, fp); putc(ch, fp);
    putc(ch, fp);
    ch = ch * 7 + 13;
  }

  rewind(fp);

  ch = 1;
  for (i = 0; i < 10000; i++) {
    if (fread(buf, 1, 13, fp) != 13) {
      fprintf(stderr, "13 byte read error\n");
      exit(1);
    }
    if (buf[0] != ch  || buf[1] != ch || buf[2] != ch  || buf[3] != ch  ||
        buf[4] != ch  || buf[5] != ch || buf[6] != ch  || buf[7] != ch  ||
        buf[8] != ch  || buf[9] != ch || buf[10] != ch || buf[11] != ch ||
        buf[12] != ch) {
      fprintf(stderr, "13 byte mismatch at step %d\n", i);
      exit(1);
    }
    ch = ch * 7 + 13;
  }

  rewind(fp);

  ch = 1;
  for (i = 0; i < 10000; i++) {
    if (fread(buf, 1, 5, fp) != 5) {
      fprintf(stderr, "5 byte read error\n");
      exit(1);
    }
    if (buf[0] != ch  || buf[1] != ch || buf[2] != ch  || buf[3] != ch  ||
        buf[4] != ch) {
      fprintf(stderr, "5 byte mismatch at step %d\n", i);
      exit(1);
    }
    if (fread(buf+5, 1, 8, fp) != 8) {
      fprintf(stderr, "8 byte read error\n");
      exit(1);
    }
    if (buf[5] != ch  || buf[6] != ch || buf[7] != ch  ||
        buf[8] != ch  || buf[9] != ch || buf[10] != ch || buf[11] != ch ||
        buf[12] != ch) {
      fprintf(stderr, "8 byte mismatch at step %d\n", i);
      exit(1);
    }
    ch = ch * 7 + 13;
  }

  exit(0);
}
