/* $Id: setlocale.c,v 1.1 1995/05/24 19:09:42 stuart Exp $ */

/*{{{}}}*/
/*{{{  #includes*/
#include <minix/locale.h>
#include <sys/types.h>
#include <fcntl.h>
#include <limits.h>
#include <locale.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/*}}}  */

/*{{{  __opennls*/
int __opennls(const char *category, const char *value, const char *charset, const char *cat)
{
  /*{{{  variables*/
  char name[_POSIX_PATH_MAX];
  char *nlspath;
  char *s;
  int fd;
  /*}}}  */

  if ((nlspath=getenv("NLSPATH"))==(char*)0) return -1;
  while (*nlspath)
  {
    s=name;
    *s='\0';
    while (*nlspath && *nlspath!=':' && s<(name+_POSIX_PATH_MAX))
    {
      if (*nlspath=='%') 
      {
        ++nlspath;
        switch (*nlspath)
        {
          /*{{{  %L*/
          case 'L': 
          {
            int leninc;
          
            leninc=strlen(category)+1+strlen(value);
            if ((s+leninc)<(name+_POSIX_PATH_MAX-1))
            {
              strcpy(s,category);
              strcat(s,"/");
              strcat(s,value);
              s+=leninc;
              break;
            }
            else return -1;
          }  
          /*}}}  */
          /*{{{  %N*/
          case 'N':
          {
            int leninc;
          
            leninc=strlen(cat);
            if ((s+leninc)<(name+_POSIX_PATH_MAX-1))
            {
              strcpy(s,cat);
              s+=leninc;
              break;
            }
            else return -1;
          }
          /*}}}  */
          default: break;
        } 
        if (*nlspath) ++nlspath;
      }
      else if (s<(name+_POSIX_PATH_MAX-1)) 
      {
        *s++=*nlspath++;
      } 
      else return -1;
    }
    *s='\0';
    if ((fd=open(name,O_RDONLY))>=0) return fd;
    else if (*nlspath) ++nlspath;
  }
  return -1;
}
/*}}}  */
/*{{{  setlocale*/
char *setlocale(int category, const char *locale)
{
  /*{{{  variables*/
  static const char *lc_collate="C";
  static const char *lc_ctype="C";
  static const char *lc_monetary="C";
  static const char *lc_messages="C";
  static const char *lc_numeric="C";
  static const char *lc_time="C";
  static char r[256];
  /*}}}  */

  switch (category)
  {
    /*{{{  LC_ALL*/
    case LC_ALL:
    {
      if (locale!=(const char *)0 && *locale==':')
      {
        char *p;
    
        p=strcpy(malloc(strlen(locale)),locale);
        setlocale(LC_COLLATE,strtok(p,":"));
        setlocale(LC_CTYPE,strtok((char*)0,":"));
        setlocale(LC_MONETARY,strtok((char*)0,":"));
        #ifdef LC_MESSAGES
        setlocale(LC_MESSAGES,strtok((char*)0,":"));
        #endif
        setlocale(LC_NUMERIC,strtok((char*)0,":"));
        setlocale(LC_TIME,strtok((char*)0,":"));
        free(p);
      }
      else if (locale!=(const char *)0)
      {
        setlocale(LC_COLLATE,locale);
        setlocale(LC_CTYPE,locale);
        setlocale(LC_MONETARY,locale);
        #ifdef LC_MESSAGES
        setlocale(LC_MESSAGES,locale);
        #endif
        setlocale(LC_NUMERIC,locale);
        setlocale(LC_TIME,locale);
      }
      strcpy(r,":");
      strcat(r,lc_collate); strcat(r,":");
      strcat(r,lc_ctype); strcat(r,":");
      strcat(r,lc_monetary); strcat(r,":");
      #ifdef LC_MESSAGES
      strcat(r,lc_messages); strcat(r,":");
      #endif
      strcat(r,lc_numeric); strcat(r,":");
      strcat(r,lc_time); strcat(r,":");
      return r;
    }
    /*}}}  */
    /*{{{  LC_COLLATE*/
    case LC_COLLATE:
    {
      if (locale)
      {
        if (*locale=='\0') locale=(const char*)getenv("LC_COLLATE");
        if (locale==(const char*)0) locale="C";
        if (strcmp(lc_collate,locale))
        {
          if (strcmp(locale,"C")==0 || strcmp(locale,"POSIX")==0) lc_collate="C";
          else return (char*)0;
        }  
      }
      return (char*)lc_collate;
    }
    /*}}}  */
    /*{{{  LC_CTYPE*/
    case LC_CTYPE:
    {
      if (locale)
      {
        if (*locale=='\0') locale=(const char*)getenv("LC_CTYPE");
        if (locale==(const char*)0) locale="C";
        if (strcmp(lc_ctype,locale))
        {
          int fd;
    
          if ((fd=__opennls("LC_CTYPE",locale,(char*)0,"ctype"))<0) return (char*)0;
          else
          {
            lc_ctype=locale;
            read(fd,__ctype_data,sizeof(__ctype_data));
            close(fd);
          }
        }
      }
      return (char*)lc_ctype;
    }
    /*}}}  */
    /*{{{  LC_MONETARY*/
    case LC_MONETARY:
    {
      if (locale)
      {
        if (*locale=='\0') locale=(const char*)getenv("LC_MONETARY");
        if (locale==(const char*)0) locale="C";
        if (strcmp(lc_monetary,locale))
        {
          if (strcmp(locale,"C")==0 || strcmp(locale,"POSIX")==0) lc_monetary="C";
          else return (char*)0;
        }  
      }
      return (char*)lc_monetary;
    }
    /*}}}  */
    /*{{{  LC_MESSAGES*/
    #ifdef LC_MESSAGES
    case LC_MESSAGES:
    {
      if (locale)
      {
        if (*locale=='\0') locale=(const char*)getenv("LC_MESSAGES");
        if (locale==(const char*)0) locale="C";
        lc_messages=locale;
      }
      return (char*)lc_messages;
    }
    #endif
    /*}}}  */
    /*{{{  LC_NUMERIC*/
    case LC_NUMERIC:
    {
      if (locale)
      {
        if (*locale=='\0') locale=(const char*)getenv("LC_NUMERIC");
        if (locale==(const char*)0) locale="C";
        if (strcmp(lc_numeric,locale))
        {
          if (strcmp(locale,"C")==0 || strcmp(locale,"POSIX")==0) lc_numeric="C";
          else return (char*)0;
        }  
      }
      return (char*)lc_numeric;
    }
    /*}}}  */
    /*{{{  LC_TIME*/
    case LC_TIME:
    {
      if (locale)
      {
        if (*locale=='\0') locale=(const char*)getenv("LC_TIME");
        if (locale==(const char*)0) locale="C";
        if (strcmp(lc_time,locale))
        {
          int fd;
          
          if ((fd=__opennls("LC_TIME",locale,lc_ctype,"strftime"))<0) return (char*)0;
          else
          {
            lc_time=locale;
            read(fd,&__strftime_locale,sizeof(__strftime_locale));
    	    close(fd);
          }
        }  
      }
      return (char*)lc_time;
    }
    /*}}}  */
    /*{{{  default*/
    default: return (char*)0;
    /*}}}  */
  }
}
/*}}}  */
