/* $Id: lc_time.c,v 1.1 1995/05/24 19:09:42 stuart Exp $ */

#include <minix/locale.h>

#if !defined(CAT)
#define C
#endif

/*{{{  C*/
#ifdef C
__strftime_locale_t __strftime_locale=
{
  { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" },
  { 
    "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", 
    "Saturday"
  },
  {
    "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", 
    "Nov", "Dec"
  },
  {
    "January", "February", "March", "April", "May", "June", "July", "August", 
    "September", "October", "November", "December"
  },
  "",
  "",
  "%a %b %d %X %Y",
  "%m/%d/%Y",
  "%H:%M:%S"
};
#endif
/*}}}  */
/*{{{  us -- USA*/
#ifdef us
__strftime_locale_t __strftime_locale=
{
  { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" },
  { 
    "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", 
    "Saturday"
  },
  {
    "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", 
    "Nov", "Dec"
  },
  {
    "January", "February", "March", "April", "May", "June", "July", "August", 
    "September", "October", "November", "December"
  },
  "am",
  "pm",
  "%a %b %d %X %Y",
  "%m/%d/%Y",
  "%I:%M:%S%p"
};
#endif
/*}}}  */
/*{{{  de -- German*/
#ifdef de
__strftime_locale_t __strftime_locale=
{
  { "So", "Mo", "Di", "Mi", "Do", "Fr", "Sa" },
  { 
    "Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", 
    "Samstag" 
  },
  {
    "Jan", "Feb", "Mr", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", 
    "Nov", "Dez"
  },
  {
    "Januar", "Februar", "Mrz", "April", "Mai", "Jun", "Juli", "August", 
    "September", "Oktober", "November", "Dezember"
  },
  "",
  "",
  "%a %b %d %X %Y",
  "%d.%m.%Y",
  "%H.%M.%S"
};
#endif
/*}}}  */
/*{{{  es -- Spanish*/
#ifdef es
__strftime_locale_t __strftime_locale=
{
  { "D", "L", "M", "X", "J", "V", "S" },
  {
    "Domingo", "Lunes", "Martes", "Mircoles", "Jueves", "Viernes", "Sbado"
  },
  {
    "Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", 
    "Nov", "Dic"
  },
  {
    "Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto",
    "Septiembre", "Octubre", "Noviembre", "Diciembre"
  },
  "de la maana",
  "de la tarde",
  "%a %b %d %X %Y",
  "%d/%m/%Y",
  "%I:%M:%S %p"
};
#endif
/*}}}  */
/*{{{  it -- Italian*/
#ifdef it
__strftime_locale_t __strftime_locale=
{
  { "Dom", "Lun", "Mar", "Mer", "Gio", "Ver", "Sab" },
  {
    "Domenica", "Luned", "Marted", "Mercoled", "Gioved", "Verned", 
    "Sabato"
  },
  {
    "Gen", "Feb", "Mar", "Apr", "Mag", "Giu", "Lug", "Ago", "Sep", "Okt", 
    "Nov", "Dez"
  },
  {
    "Gennaio", "Febbraio", "Marzo", "Aprile", "Maggio", "Giugno", "Luglio", 
    "Agosto", "Settembre", "Ottobre", "Novembre", "Dicembre"
  },
  "",
  "",
  "%a %b %d %X %Y",
  "%d/%m/%Y", /* XXX */
  "%H:%M:%S"
};
#endif
/*}}}  */
/*{{{  fr -- French*/
#ifdef fr
__strftime_locale_t __strftime_locale=
{
  { "Dim", "Lun", "Mar", "Mer", "Jeu", "Ven", "Sam" },
  {
    "Dimanche", "Lundi", "Mardi", "Mercredi", "Jeudi", "Vendredi", "Samedi"
  },
  {
    "Jan", "Fev", "Mar", "Avr", "Mai", "Jui", "Juil", "Ao", "Sep", "Oct", 
    "Nov", "Dec"
  },
  {
    "Janvier", "Fvrier", "Mars", "Avril", "Mai", "Juin", "Juillet", "Aot", 
    "Septembre", "Octobre", "Novembre", "Dcembre"
  },
  "",
  "",
  "%a %b %d %X %Y",
  "%d/%m/%Y",
  "%H:%M:%S"
};
#endif
/*}}}  */
/*{{{  fi -- Finnish*/
#ifdef fi
__strftime_locale_t __strftime_locale=
{
  { "Su", "Ma", "Ti", "Ke", "To", "Pe", "La" },
  {
    "Sunnuntai", "Maanantai", "Tiistai", "Keskiviikko", "Torstai", 
    "Perjantai", "Lauantai"
  },
  {
    "Tammi", "Helmi", "Maalis", "Huhti", "Tou", "Kes", "Hein", "Elo",
    "Syys", "Loka", "Marras", "Joulu"
  },
  {
    "Tammikuu", "Helmikuu", "Maaliskuu", "Huhtikuu", "Toukokuu", "Keskuu",
    "Heinkuu", "Elokuu", "Syyskuu", "Lokakuu", "Marraskuu", "Joulukuu"
  },
  "",
  "",
  "%a %b %d %X %Y",
  "%d.%m.%Y",
  "%H:%M:%S"
};
#endif
/*}}}  */
/*{{{  se -- Swedish*/
#ifdef se
__strftime_locale_t __strftime_locale=
{
  { "Sn", "Mn", "Tis", "Ons", "Tors", "Fre", "Lr" },
  { "Sndag", "Mndag", "Tisdag", "Onsdag", "Torsdag", "Fredag", "Lrdag" },
  {
    "Jan", "Feb", "Mar", "Apr", "Maj", "Jun", "Jul", "Aug", "Sep", "Okt", 
    "Nov", "Dec"
  },
  {
    "Januari", "Februari", "Mars", "April", "Maj", "Juni", "Juli", "Augusti", 
    "September", "Oktober", "November", "December"
  },
  "",
  "",
  "%a %b %d %X %Y",
  "%Y-%m-%d",
  "%H:%M:%S"
};
#endif
/*}}}  */
/*{{{  no -- Norge*/
#ifdef no
__strftime_locale_t __strftime_locale=
{
  { "Sn", "Man", "Tir", "Ons", "Tor", "Fre", "Lr" },
  { "Sndag", "Mandag", "Tirsdag", "Onsdag", "Torsdag", "Fredag", "Lrdag" },
  {
    "Jan", "Feb", "Mar", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", 
    "Nov", "Des"
  },
  {
    "Januar", "Februar", "Mars", "April", "Mai", "Juni", "Juli", "August", 
    "September", "Oktober", "November", "Desember"
  },
  "",
  "",
  "%a %b %d %X %Y",
  "%d.%m.%Y",
  "%H:%M:%S"
};
#endif
/*}}}  */
/*   pl -- Polnish.  Nobody wanted to tell me on irc, so I guess it is secret. */
/*   be -- They don't have their own language. */
/*{{{  nl -- Dutch*/
#ifdef nl
__strftime_locale_t __strftime_locale=
{
  { "Zo", "Ma", "Di", "Wo", "Do", "Vr", "Za" },
  { 
    "Zondag", "Maandag", "Dinsdag", "Woensdag", "Donderdag", "Vrijdag", 
    "Zaterdag"
  },
  {
    "Jan", "Feb", "Mrt", "Apr", "Mei", "Jun", "Jul", "Aug", "Sep", "Oct", 
    "Nov", "Dec"
  },
  {
    "Januari", "Februari", "Maart", "April", "Mei", "Juni", "Juli", 
    "Augustus", "September", "October", "November", "December"
  },
  "",
  "",
  "%a %b %d %X %Y",
  "%d-%m-%Y",
  "%H.%M.%S"
};
#endif
/*}}}  */
