/*
 * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
 * See the copyright notice in the ACK home directory, in the file "Copyright".
 */
/* $Header: /home/dogmatix/users/stuart/minix/tpsrc/1.6.25/usr/src/lib/c/ansi/RCS/getenv.c,v 1.2 1995/10/27 20:27:51 stuart Exp $ */

#include	<stdlib.h>

extern const char **_penvp;

char *
getenv(const char *name)
{
	register const char **v = _penvp;
	register const char *p, *q;

	if (v == NULL || name == NULL)
		return (char *)NULL;
	while ((p = *v++) != NULL) {
		q = name;
		while (*q && (*q == *p++))
			q++;
		if (*q || (*p != '='))
			continue;
		return (char *)p + 1;
	}
	return (char *)NULL;
}
