/*{{{  #includes*/
#include <chan.h>
#include <afserver.h>
/*}}}  */

/*{{{  #defines*/
#define INT32_VALUE 4
#define NILRECORD_VALUE 8
#define RECORD32_VALUE 12
/*}}}  */

/*{{{  data_put_int*/
void data_put_int(int i, CHAN *chan)
{
  chan_out_byte(INT32_VALUE, chan);
  chan_out_word(i, chan);
}
/*}}}  */
/*{{{  data_get_int*/
void data_get_int(int *i, CHAN *chan)
{
  char dummy;

  chan_in_byte(&dummy, chan);
  chan_in_word(i, chan);
}
/*}}}  */
/*{{{  data_put_rec*/
void data_put_rec(int l, char *r, CHAN *chan)
{
  if (l==0)
  /*{{{  nil record special case*/
  {
    chan_out_byte(NILRECORD_VALUE, chan);
  }
  /*}}}  */
  else
  /*{{{  non nil record*/
  {
    chan_out_byte(RECORD32_VALUE,chan);
    chan_out_word(l,chan);
    chan_out_message(l,r,chan);
  }
  /*}}}  */
}
/*}}}  */
/*{{{  data_get_rec*/
void data_get_rec(int *l, char *r, CHAN *chan)
{
  char tag;

  chan_in_byte(&tag, chan);
  if (tag==NILRECORD_VALUE)
  /*{{{  nil record special case*/
  {
    *l=0;
  }
  /*}}}  */
  else
  /*{{{  non-nil record*/
  {
    chan_in_word(l, chan);
    chan_in_message(*l, r, chan);
  }
  /*}}}  */
}
/*}}}  */
