#define write _write
/*{{{}}}*/
/*{{{  #includes*/
#include "lib.h"
/*}}}  */

/*{{{  write*/
ssize_t write(int fd, const void *buffer, size_t len)
{
  if (fd<0 || fd>=_POSIX_OPEN_MAX || !__fileused[fd])
  {
    errno=EINVAL;
    return -1;
  }

  data_put_int(__WRITEBLOCK,Link0Output);
  data_put_int(__filedesc[fd],Link0Output);
  data_put_rec(len,buffer,Link0Output);

  data_get_int((signed int*)&len,Link0Input);
  data_get_int(&errno,Link0Input);

  __filepos[fd]+=len;

  return (errno==EOK ? len : -1);
}
/*}}}  */
