#define read _read
/*{{{}}}*/
/*{{{  #includes*/
#include "lib.h"

#include <unistd.h>
/*}}}  */

/*{{{  read*/
ssize_t read(int fd, void *buffer, size_t len)
{
  if (fd<0 || fd>=_POSIX_OPEN_MAX || !__fileused[fd])
  {
    errno=EINVAL;
    return -1;
  }

  if (fd==0 && len>1) len=1;

  data_put_int(__READBLOCK,Link0Output);
  data_put_int(__filedesc[fd],Link0Output);
  data_put_int(len,Link0Output);

  data_get_rec((signed int*)&len,buffer,Link0Input);
  data_get_int(&errno,Link0Input);

  __filepos[fd]+=len;

  return (errno==EOK ? len : -1);
}
/*}}}  */
