#define open _open
/*{{{}}}*/
/*{{{  #includes*/
#include "lib.h"

#include <fcntl.h>
#include <unistd.h>
#include <string.h>
/*}}}  */

/*{{{  open*/
int open(const char *file_name, int flag, ...)
{
  int fd,acc,op,exist;

  for (fd=0; fd<_POSIX_OPEN_MAX && __fileused[fd]; fd++);
  if (fd==_POSIX_OPEN_MAX) { errno=ENFILE; return -1; }
  data_put_int(__OPEN,Link0Output);
  data_put_rec(strlen(file_name),(char*)file_name,Link0Output);
  data_put_int(0,Link0Output);
  if (flag&O_WRONLY) op=1; else if (flag&O_RDWR) op=2; else op=0;
  data_put_int(op,Link0Output);
  data_put_int((flag&O_CREAT ? 1 : 0)|(flag&O_APPEND ? 2 : 0), Link0Output);
  data_put_int(0,Link0Output);
  data_get_int(&__filedesc[fd],Link0Input);
  data_get_int(&errno,Link0Input);
  if (errno==EOK)
  {
    __fileused[fd]=1;
    __filepos[fd]=0;
    return fd;
  }
  else return -1;
}
/*}}}  */
