#define lseek _lseek
/*{{{}}}*/
/*{{{  #includes*/
#include "lib.h"

#include <unistd.h>
/*}}}  */

/*{{{  lseek*/
off_t lseek(int fd, off_t offset, int whence)
{
  int len;

  if (fd<0 || fd>=_POSIX_OPEN_MAX || !__fileused[fd]) { errno=EINVAL; return -1; }
  if (whence==SEEK_END)
  /*{{{  find out len and convert offset to SEEK_BEG*/
  {
    data_put_int(__STREAMLEN,Link0Output);
    data_put_int(__filedesc[fd],Link0Output);
    data_get_int(&len,Link0Input);
    data_get_int(&errno,Link0Input);
    if (errno!=EOK) return -1;
    offset+=len;
  }
  /*}}}  */
  else if (whence==SEEK_CUR)
  /*{{{  convert offset to SEEK_BEG*/
  offset+=__filepos[fd];
  /*}}}  */
  data_put_int(__SEEK,Link0Output);
  data_put_int(__filedesc[fd],Link0Output);
  data_put_int(offset,Link0Output);
  data_get_int(&errno,Link0Input);
  return (errno==EOK ? __filepos[fd]=offset : -1);
}
/*}}}  */
