/* $Id: utmp.h,v 1.4 1995/10/27 18:45:53 stuart Exp $ */

#ifndef _UTMP_H
#define _UTMP_H

#include <paths.h>
#include <sys/types.h>
#include <time.h>

#define WTMP_FILE      _PATH_WTMP       /* the login history file            */
#define UTMP_FILE      _PATH_UTMP       /* the user accouting file           */

#define UT_NAMESIZE    8
#define UT_LINESIZE    12
#define UT_HOSTSIZE    64

/* Definitions for ut_type. */
#define RUN_LVL        1                /* this is a RUN_LEVEL record        */
#define BOOT_TIME      2                /* this is a REBOOT record           */
#define NEW_TIME       3                /* logging new time                  */
#define OLD_TIME       4                /* logging previous time             */
#define INIT_PROCESS   5                /* this process was spawned by INIT  */
#define LOGIN_PROCESS  6                /* this is a 'getty' process waiting */
#define USER_PROCESS   7                /* any other user process            */
#define DEAD_PROCESS   8                /* this process has died             */

struct utmp
{
  char ut_user[UT_NAMESIZE];            /* user name                         */
  char ut_id[2];                        /* /etc/inittab ID                   */
  char ut_line[UT_LINESIZE];            /* terminal name                     */
  char ut_host[UT_HOSTSIZE];            /* host name, when remote            */
  pid_t ut_pid;                         /* process id                        */
  short int ut_type;                    /* type of entry                     */
  time_t ut_time;                       /* login/logout time                 */
};

#define ut_name ut_user		/* for compatibility with other systems */

struct utmp *getutent(void);
struct utmp *getutid(struct utmp *id);
struct utmp *getutline(struct utmp *line);
void pututline(struct utmp *new);
void setutent(void);
void endutent(void);
void utmpname(const char *file);

#endif
