/* $Id: unistd.h,v 1.3 1995/11/01 10:49:00 stuart Exp $ */

#ifndef _UNISTD_H
#define _UNISTD_H

#include <minix/types.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _POSIX_SOURCE

/* Values used by access().  POSIX Table 2-8. */
#define F_OK               0	/* test if file exists */
#define X_OK               1	/* test if file is executable */
#define W_OK               2	/* test if file is writable */
#define R_OK               4	/* test if file is readable */

/* Values used for whence in lseek(fd, offset, whence).  POSIX Table 2-9. */
#define SEEK_SET           0	/* offset is absolute  */
#define SEEK_CUR           1	/* offset is relative to current position */
#define SEEK_END           2	/* offset is relative to end of file */

/* This value is required by POSIX Table 2-10. */
#define _POSIX_VERSION 199009L	/* which standard is being conformed to */

/* These three definitions are required by POSIX Sec. 8.2.1.2. */
#define STDIN_FILENO       0	/* file descriptor for stdin */
#define STDOUT_FILENO      1	/* file descriptor for stdout */
#define STDERR_FILENO      2	/* file descriptor for stderr */

/* The following relate to configurable system variables. POSIX Table 4-2. */
#define _SC_ARG_MAX		1
#define _SC_CHILD_MAX		2
#define _SC_CLOCKS_PER_SEC	3
#define _SC_CLK_TCK             3
#define _SC_NGROUPS_MAX		4
#define _SC_OPEN_MAX		5
#define _SC_JOB_CONTROL		6
#define _SC_SAVED_IDS		7
#define _SC_VERSION		8
#define _SC_STREAM_MAX		9
#define _SC_TZNAME_MAX         10

/* The following relate to configurable pathname variables. POSIX Table 5-2. */
#define _PC_LINK_MAX		1	/* link count */
#define _PC_MAX_CANON		2	/* size of the canonical input queue */
#define _PC_MAX_INPUT		3	/* type-ahead buffer size */
#define _PC_NAME_MAX		4	/* file name size */
#define _PC_PATH_MAX		5	/* pathname size */
#define _PC_PIPE_BUF		6	/* pipe size */
#define _PC_NO_TRUNC		7	/* treatment of long name components */
#define _PC_VDISABLE		8	/* tty disable */
#define _PC_CHOWN_RESTRICTED	9	/* chown restricted or not */

/* POSIX defines several options that may be implemented or not, at the
 * implementer's whim.  This implementer has made the following choices:
 *
 * _POSIX_JOB_CONTROL	    not defined:	no job control
 * _POSIX_SAVED_IDS 	    not defined:	no saved uid/gid
 * _POSIX_NO_TRUNC	    defined as -1:	long path names are truncated
 * _POSIX_CHOWN_RESTRICTED  defined:		you can't give away files
 * _POSIX_VDISABLE	    defined:		tty functions can be disabled
 */
#define _POSIX_NO_TRUNC       (-1)
#define _POSIX_CHOWN_RESTRICTED  1
#define _POSIX_VDISABLE       0xDF

void _exit(int _status);
int access(const char *_path, int _amode);
unsigned int alarm(unsigned int _seconds);
int chdir(const char *_path);
int chown(const char *_path, __uid_t _owner, __gid_t _group);
int close(int _fd);
char *ctermid(char *_s);
char *cuserid(char *_s);
int dup(int _fd);
int dup2(int _fd, int _fd2);
int execl(const char *_path, const char *_arg, ...);
int execle(const char *_path, const char *_arg, ...);
int execlp(const char *_file, const char *arg, ...);
int execv(const char *_path, char *const _argv[]);
int execve(const char *_path, char *const _argv[], char *const _envp[]);
int execvp(const char *_file, char *const _argv[]);
__pid_t fork(void);
long fpathconf(int _fd, int _name);
char *getcwd(char *_buf, __size_t _size);
__gid_t getegid(void);
__uid_t geteuid(void);
__gid_t getgid(void);
int getgroups(int _gidsetsize, __gid_t _grouplist[]);
char *getlogin(void);
__pid_t getpgrp(void);
__pid_t getpid(void);
__pid_t getppid(void);
__uid_t getuid(void);
int isatty(int _fd);
int link(const char *_existing, const char *_new);
__off_t lseek(int _fd, __off_t _offset, int _whence);
long pathconf(const char *_path, int _name);
int pause(void);
int pipe(int _fildes[2]);
__ssize_t read(int _fd, void *_buf, __size_t _n);
int rmdir(const char *_path);
int setgid(__gid_t _gid);
int setpgid(__pid_t _pid, __pid_t _pgid);
__pid_t setsid(void);
int setuid(__uid_t _uid);
unsigned int sleep(unsigned int _seconds);
long sysconf(int _name);
__pid_t tcgetpgrp(int _fd);
int tcsetpgrp(int _fd, __pid_t _pgrp_id);
char *ttyname(int _fd);
int unlink(const char *_path);
__ssize_t write(int _fd, const void *_buf, __size_t _n);

#endif

#ifdef _MINIX
int brk(char *_addr);
int chroot(const char *_name);
int mknod(const char *_name, __mode_t _mode, __dev_t _addr);
int mknod4(const char *_name, __mode_t _mode, __dev_t _addr, long _size);
char *mktemp(char *_template);
int mount(char *_spec, char *_name, int _flag);
long ptrace(int _req, __pid_t _pid, long _addr, long _data);
char *sbrk(int _incr);
int sync(void);
int umount(const char *_name);
int reboot(int _how);
int gethostname(char *_hostname, __size_t _len);
int getdomainname(char *_domain, __size_t _len);
int readlink(const char *_path, char *_buf, int _len);
int symlink(const char *_path1, const char *_path2);
char *crypt(const char *key, const char *salt);
void encrypt(char block[64], int edflag);
#endif

#ifdef __cplusplus
}
#endif

#endif
