/* $Id: support.h,v 1.2 1995/06/22 21:08:50 stuart Exp $ */

/* Support functions provided in the library. */

#ifndef _TRANSPUTER_SUPPORT_H
#define _TRANSPUTER_SUPPORT_H

typedef void (*hpp_t)();
void run_process(int* stack, hpp_t, int, ...);
void tsleep(unsigned int delay_ticks);

#ifndef _TRANSPUTER_CHANNEL_H
#include <transputer/channel.h>
#endif
#ifndef _TRANSPUTER_SEM_H
#include <transputer/sem.h>
#endif

/* Tasks can find out details about the boot link by sending a SYS_BLINK
 * message to the SYSTEM task. This returns a pointer to a shared
 * data structure which contains details about the boot link, and a
 * semaphore to protect against multiple processes performing I/O at the
 * same time.
 */
struct link_details {
    channel_t* linkIn;
    channel_t* linkOut;
    semaphore_t sem;
};

#endif /* _TRANSPUTER_SUPPORT_H */

