/* $Id: iserver.h,v 1.2 1994/08/02 16:32:52 stuart Exp $ */

/* Defintions of constants used by the Inmos IServer */

/* File commands. */
#define SP_OPEN       10
#define SP_CLOSE      11
#define SP_READ       12
#define SP_WRITE      13
#define SP_GETS       14
#define SP_PUTS       15
#define SP_FLUSH      16
#define SP_SEEK       17
#define SP_TELL       18
#define SP_EOF        19
#define SP_FERROR     20
#define SP_REMOVE     21
#define SP_RENAME     22
#define SP_GETBLOCK   23
#define SP_PUTBLOCK   24

/* Host commands. */
#define SP_GETKEY     30
#define SP_POLLKEY    31
#define SP_GETENV     32
#define SP_TIME       33
#define SP_SYSTEM     34
#define SP_EXIT       35

/* Server commands. */
#define SP_COMMAND    40
#define SP_CORE       41
#define SP_ID         42
#define SP_GETINFO    43


/* Host specific tags. */
#define SP_MSDOS      50
#define SP_SUN        60
#define SP_MSC        61
#define SP_VMS        62

/* Vendor specific tags. */
#define SP_ALSYS      100
#define SP_KPAR       101

/* Result codes. */
#define ER_SUCCESS       0
#define ER_UNIMPLEMENTED 1
#define ER_ERROR         129

/* SP_GETINFO request tags */
#define INFO_SWITCH        1
#define INFO_EOL           2
#define INFO_STDERR        3
#define INFO_SERVERID      4
#define INFO_SERVERMAJ     5
#define INFO_SERVERMIN     6
#define INFO_PKTSIZE       7

/* Functions which tasks can use directly (from low priority) to access
 * the IServer.
 */
#ifndef _MINIX_TYPE_H
#include <minix/type.h> /* Needed for iovec_t */
#endif
 
void iserver_message(iovec_t *iov, unsigned int write, unsigned int read);

void iserver_init(void);
int  iserver_open(const char* filename, int org, int mode, int* fd);
int  iserver_seek(int fd, long position);
int  iserver_error(int fd, int* error, char* string, int string_len);
int  iserver_read(int fd, void* buffer, int count);
int  iserver_write(int fd, const void* buffer, int count);
int  iserver_close(int fd);
int  iserver_time(clock_t times[2]);

/* Variables exported by the IServer library. */
extern int iserver_version;            /* /10 = major, %10 = minor */
extern int iserver_max_packet_size;    /* including 2 byte length */
extern int iserver_block_ops;
