/* $Id: channel.h,v 1.3 1995/11/01 10:51:24 stuart Exp $ */

/* Defintions relating to channels. */

#ifndef _TRANSPUTER_CHANNEL_H
#define _TRANSPUTER_CHANNEL_H

#ifndef _MINIX_TYPES_H
#include <minix/types.h>
#endif

typedef volatile void *channel_t;

#ifdef _ICC
/* If we can perform these operations inline, do so. */
extern void DirectChanIn(channel_t *c, void *data, int count);
extern int  DirectChanInChar(channel_t *c);
extern int  DirectChanInInt(channel_t *c);
extern void DirectChanOut(channel_t *c, const void *data, int count);
extern void DirectChanOutChar(channel_t *c, unsigned char val);
extern void DirectChanOutInt(channel_t *c, int val);

#pragma IMS_builtin_inline(DirectChanIn)
#pragma IMS_builtin_inline(DirectChanInChar)
#pragma IMS_builtin_inline(DirectChanInInt)
#pragma IMS_builtin_inline(DirectChanOut)
#pragma IMS_builtin_inline(DirectChanOutChar)
#pragma IMS_builtin_inline(DirectChanOutInt)

#define ChanIn(c, data, count)  DirectChanIn(c, data, count)
#define ChanInByte(c)           DirectChanInChar(c)
#define ChanOut(c, data, count) DirectChanOut(c, data, count)
#define ChanOutByte(c, v)       DirectChanOutChar(c, v)

#if _PTYPE == '2' || _PTYPE == '3'
/* Channel IO for 16 bit processors */
#define ChanInInt16(c)          DirectChanInInt(c)
#define ChanOutInt16(c, v)      DirectChanOutInt(c, v)

extern long ChanInInt32(channel_t *c);
extern void ChanOutInt32(channel_t *c, long val);
#else
/* Channel IO for 32 bit processors */
#define ChanInInt32(c)          DirectChanInInt(c)
#define ChanOutInt32(c, v)      DirectChanOutInt(c, v)

extern int  ChanInInt16(channel_t *c);
extern void ChanOutInt16(channel_t *c, int val);
#endif

#else /* _ICC */
/* We have to do real function calls. */
extern void ChanIn(channel_t *c, void *data, int count);
extern int  ChanInByte(channel_t *c);
extern int  ChanInInt16(channel_t *c);
extern long ChanInInt32(channel_t *c);
extern void ChanOut(channel_t *c, const void *data, int count);
extern void ChanOutByte(channel_t *c, unsigned char val);
extern void ChanOutInt16(channel_t *c, int val);
extern void ChanOutInt32(channel_t *c, long val);
#endif

#ifndef MININT
#define MININT (0x80000000)
#endif

extern int ChanInTimeFail(channel_t *c, void *data, int count, __clock_t timeout);
extern int ChanOutTimeFail(channel_t *c, void *data, int count, __clock_t timeout);
extern int ChanInChanFail(channel_t *c, void *data, int count, channel_t* fail);
extern int ChanOutChanFail(channel_t *c, void *data, int count, channel_t* fail);

#endif /* _CHANNEL_H */
